/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.io;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.VisitLifecycleCleanable;
import org.milyn.delivery.dom.DOMVisitBefore;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.w3c.dom.Element;

public abstract class AbstractOutputStreamResource
implements SAXVisitBefore,
DOMVisitBefore,
Consumer,
VisitLifecycleCleanable,
ExecutionLifecycleCleanable {
    Log log = LogFactory.getLog(AbstractOutputStreamResource.class);
    protected static final String RESOURCE_CONTEXT_KEY_PREFIX = AbstractOutputStreamResource.class.getName() + "#outputresource:";
    private static final String OUTPUTSTREAM_CONTEXT_KEY_PREFIX = AbstractOutputStreamResource.class.getName() + "#outputstream:";
    @ConfigParam
    private String resourceName;
    @ConfigParam(defaultVal="UTF-8")
    private Charset writerEncoding = Charset.forName("UTF-8");

    public abstract OutputStream getOutputStream(ExecutionContext var1) throws IOException;

    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public boolean consumes(Object object) {
        return object.equals(this.resourceName);
    }

    public AbstractOutputStreamResource setResourceName(String resourceName) {
        AssertArgument.isNotNullAndNotEmpty((String)resourceName, (String)"resourceName");
        this.resourceName = resourceName;
        return this;
    }

    public AbstractOutputStreamResource setWriterEncoding(Charset writerEncoding) {
        AssertArgument.isNotNull((Object)writerEncoding, (String)"writerEncoding");
        this.writerEncoding = writerEncoding;
        return this;
    }

    public Charset getWriterEncoding() {
        return this.writerEncoding;
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.bind(executionContext);
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.bind(executionContext);
    }

    @Override
    public void executeVisitLifecycleCleanup(Fragment fragment, ExecutionContext executionContext) {
        if (this.closeCondition(executionContext)) {
            this.closeResource(executionContext);
        }
    }

    @Override
    public void executeExecutionLifecycleCleanup(ExecutionContext executionContext) {
        this.closeResource(executionContext);
    }

    protected boolean closeCondition(ExecutionContext executionContext) {
        return true;
    }

    public static OutputStream getOutputStream(String resourceName, ExecutionContext executionContext) throws SmooksException {
        String resourceKey = OUTPUTSTREAM_CONTEXT_KEY_PREFIX + resourceName;
        Object resourceIOObj = executionContext.getAttribute(resourceKey);
        if (resourceIOObj == null) {
            AbstractOutputStreamResource resource = (AbstractOutputStreamResource)executionContext.getAttribute(RESOURCE_CONTEXT_KEY_PREFIX + resourceName);
            OutputStream outputStream = AbstractOutputStreamResource.openOutputStream(resource, resourceName, executionContext);
            executionContext.setAttribute(resourceKey, outputStream);
            return outputStream;
        }
        if (resourceIOObj instanceof OutputStream) {
            return (OutputStream)resourceIOObj;
        }
        if (resourceIOObj instanceof Writer) {
            throw new SmooksException("An Writer to the '" + resourceName + "' resource is already open.  Cannot open an OutputStream to this resource now!");
        }
        throw new RuntimeException("Invalid runtime ExecutionContext state. Value stored under context key '" + resourceKey + "' must be either and OutputStream or Writer.  Is '" + resourceIOObj.getClass().getName() + "'.");
    }

    public static Writer getOutputWriter(String resourceName, ExecutionContext executionContext) throws SmooksException {
        String resourceKey = OUTPUTSTREAM_CONTEXT_KEY_PREFIX + resourceName;
        Object resourceIOObj = executionContext.getAttribute(resourceKey);
        if (resourceIOObj == null) {
            AbstractOutputStreamResource resource = (AbstractOutputStreamResource)executionContext.getAttribute(RESOURCE_CONTEXT_KEY_PREFIX + resourceName);
            OutputStream outputStream = AbstractOutputStreamResource.openOutputStream(resource, resourceName, executionContext);
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, resource.getWriterEncoding());
            executionContext.setAttribute(resourceKey, outputStreamWriter);
            return outputStreamWriter;
        }
        if (resourceIOObj instanceof Writer) {
            return (Writer)resourceIOObj;
        }
        if (resourceIOObj instanceof OutputStream) {
            throw new SmooksException("An OutputStream to the '" + resourceName + "' resource is already open.  Cannot open a Writer to this resource now!");
        }
        throw new RuntimeException("Invalid runtime ExecutionContext state. Value stored under context key '" + resourceKey + "' must be either and OutputStream or Writer.  Is '" + resourceIOObj.getClass().getName() + "'.");
    }

    private static OutputStream openOutputStream(AbstractOutputStreamResource resource, String resourceName, ExecutionContext executionContext) {
        if (resource == null) {
            throw new SmooksException("OutputResource '" + resourceName + "' not bound to context.  Configure an '" + AbstractOutputStreamResource.class.getName() + "' implementation, or change resource ordering.");
        }
        try {
            return resource.getOutputStream(executionContext);
        }
        catch (IOException e) {
            throw new SmooksException("Unable to set outputstream for '" + resource.getResourceName() + "'.", e);
        }
    }

    protected void closeResource(ExecutionContext executionContext) {
        try {
            Closeable output = (Closeable)executionContext.getAttribute(OUTPUTSTREAM_CONTEXT_KEY_PREFIX + this.getResourceName());
            this.close(output);
        }
        finally {
            executionContext.removeAttribute(OUTPUTSTREAM_CONTEXT_KEY_PREFIX + this.getResourceName());
            executionContext.removeAttribute(RESOURCE_CONTEXT_KEY_PREFIX + this.getResourceName());
        }
    }

    private void bind(ExecutionContext executionContext) {
        executionContext.setAttribute(RESOURCE_CONTEXT_KEY_PREFIX + this.getResourceName(), this);
    }

    private void close(Closeable closeable) {
        if (closeable == null) {
            return;
        }
        if (closeable instanceof Flushable) {
            try {
                ((Flushable)((Object)closeable)).flush();
            }
            catch (IOException e) {
                this.log.debug((Object)("IOException while trying to flush output resource '" + this.resourceName + "': "), (Throwable)e);
            }
        }
        try {
            closeable.close();
        }
        catch (IOException e) {
            this.log.debug((Object)("IOException while trying to close output resource '" + this.resourceName + "': "), (Throwable)e);
        }
    }
}

