/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath;

import java.util.List;
import java.util.Properties;
import javassist.CannotCompileException;
import javassist.NotFoundException;
import javax.xml.namespace.QName;
import org.jaxen.expr.NameStep;
import org.jaxen.expr.Step;
import org.jaxen.saxpath.SAXPathException;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.xpath.evaluators.PassThruEvaluator;
import org.milyn.cdr.xpath.evaluators.PredicatesEvaluator;
import org.milyn.cdr.xpath.evaluators.PredicatesEvaluatorBuilder;
import org.milyn.cdr.xpath.evaluators.XPathExpressionEvaluator;
import org.milyn.cdr.xpath.evaluators.equality.AbstractEqualityEvaluator;
import org.milyn.cdr.xpath.evaluators.logical.AbstractLogicalEvaluator;
import org.milyn.cdr.xpath.evaluators.value.TextValue;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.xml.DomUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectorStep {
    public static final long NO_ELEMENT_INDEX = -1L;
    private String xpathExpression;
    private Step step;
    private Step attributeStep;
    private boolean isRooted;
    private boolean isStar;
    private boolean isStarStar;
    private QName targetElement;
    private QName targetAttribute;
    private XPathExpressionEvaluator predicatesEvaluator;

    public SelectorStep(String xpathExpression) {
        AssertArgument.isNotNull((Object)xpathExpression, (String)"xpathExpression");
        this.xpathExpression = xpathExpression;
        this.targetElement = new QName(xpathExpression);
        this.initFlags();
    }

    public SelectorStep(String xpathExpression, Step step) throws SAXPathException {
        AssertArgument.isNotNull((Object)xpathExpression, (String)"xpathExpression");
        AssertArgument.isNotNull((Object)step, (String)"step");
        this.xpathExpression = xpathExpression;
        this.step = step;
        this.targetElement = this.toQName(step, null);
        this.initFlags();
    }

    public SelectorStep(String xpathExpression, Step step, Step attributeStep) throws SAXPathException {
        this(xpathExpression, step);
        AssertArgument.isNotNull((Object)attributeStep, (String)"attributeStep");
        if (attributeStep.getAxis() != 9) {
            throw new IllegalArgumentException("Unexpected 'attributeStep' arg '" + attributeStep.getText() + "'.  Must be an ATTRIBUTE Axis step.");
        }
        this.setAttributeStep(attributeStep);
        this.initFlags();
    }

    public SelectorStep(String xpathExpression, String targetElementName) {
        AssertArgument.isNotNull((Object)xpathExpression, (String)"xpathExpression");
        AssertArgument.isNotNull((Object)targetElementName, (String)"targetElementName");
        this.xpathExpression = xpathExpression;
        this.targetElement = new QName(targetElementName);
        this.initFlags();
    }

    public SelectorStep(String xpathExpression, String targetElementName, String targetAttributeName) {
        this(xpathExpression, targetElementName);
        AssertArgument.isNotNull((Object)targetAttributeName, (String)"targetAttributeName");
        this.targetAttribute = new QName(targetAttributeName);
    }

    public Step getAttributeStep() {
        return this.attributeStep;
    }

    public void setAttributeStep(Step attributeStep) {
        this.attributeStep = attributeStep;
        try {
            this.targetAttribute = this.toQName(attributeStep, null);
        }
        catch (SAXPathException e) {
            throw new IllegalStateException("Unexpected SAXPathException setting attribute SelectorStep.", e);
        }
    }

    public SelectorStep clone() {
        SelectorStep clone = new SelectorStep(this.xpathExpression);
        clone.xpathExpression = this.xpathExpression;
        clone.step = this.step;
        clone.attributeStep = this.attributeStep;
        clone.isRooted = this.isRooted;
        clone.isStar = this.isStar;
        clone.isStarStar = this.isStarStar;
        clone.targetElement = this.targetElement;
        clone.targetAttribute = this.targetAttribute;
        clone.predicatesEvaluator = this.predicatesEvaluator;
        return clone;
    }

    private void initFlags() {
        this.isStar = this.targetElement.getLocalPart().equals("*");
        this.isStarStar = this.targetElement.getLocalPart().equals("**");
        this.setRooted(this.targetElement.getLocalPart().equals("#document"));
    }

    public String getXPathExpression() {
        return this.xpathExpression;
    }

    public QName getTargetElement() {
        return this.targetElement;
    }

    public QName getTargetAttribute() {
        return this.targetAttribute;
    }

    public XPathExpressionEvaluator getPredicatesEvaluator() {
        return this.predicatesEvaluator;
    }

    public boolean isRooted() {
        return this.isRooted;
    }

    public void setRooted(boolean rooted) {
        this.isRooted = rooted;
        if (this.isStarStar) {
            this.isRooted = false;
        }
    }

    public boolean isStar() {
        return this.isStar;
    }

    public boolean isStarStar() {
        return this.isStarStar;
    }

    public void buildPredicatesEvaluator(Properties namespaces) throws SAXPathException, NotFoundException, CannotCompileException, IllegalAccessException, InstantiationException {
        AssertArgument.isNotNull((Object)namespaces, (String)"namespaces");
        if (this.predicatesEvaluator != null) {
            return;
        }
        if (this.step != null) {
            PredicatesEvaluatorBuilder builder = new PredicatesEvaluatorBuilder(this.step, this.attributeStep, this, namespaces);
            try {
                this.predicatesEvaluator = builder.build();
            }
            catch (SAXPathException e) {
                throw new SAXPathException("Error processing XPath selector expression '" + this.xpathExpression + "'.", (Throwable)e);
            }
            this.targetElement = this.toQName(this.step, builder);
            if (this.attributeStep != null) {
                this.targetAttribute = this.toQName(this.attributeStep, builder);
            }
        } else {
            this.predicatesEvaluator = PassThruEvaluator.INSTANCE;
        }
    }

    public boolean isTargetedAtElement(SAXElement element) {
        QName qname = element.getName();
        if (this.isStar || this.isStarStar) {
            return true;
        }
        if (!qname.getLocalPart().equalsIgnoreCase(this.targetElement.getLocalPart())) {
            return false;
        }
        return this.isTargetedAtNamespace(qname.getNamespaceURI());
    }

    public boolean isTargetedAtElement(Element element) {
        String elementName = DomUtils.getName(element);
        if (this.isStar || this.isStarStar) {
            return true;
        }
        if (!elementName.equalsIgnoreCase(this.targetElement.getLocalPart())) {
            return false;
        }
        return this.isTargetedAtNamespace(element.getNamespaceURI());
    }

    public boolean isTargetedAtNamespace(String namespace) {
        String targetNS = this.targetElement.getNamespaceURI();
        if (targetNS == null || targetNS.equals("")) {
            return true;
        }
        return targetNS.equals(namespace);
    }

    public boolean accessesText() {
        XPathExpressionEvaluator evaluator = this.getPredicatesEvaluator();
        if (evaluator == null) {
            return false;
        }
        return this.accessesText(evaluator);
    }

    private boolean accessesText(XPathExpressionEvaluator evaluator) {
        if (evaluator instanceof AbstractEqualityEvaluator) {
            if (((AbstractEqualityEvaluator)evaluator).getLhs() instanceof TextValue) {
                return true;
            }
            if (((AbstractEqualityEvaluator)evaluator).getRhs() instanceof TextValue) {
                return true;
            }
        } else if (evaluator instanceof AbstractLogicalEvaluator) {
            if (this.accessesText(((AbstractLogicalEvaluator)evaluator).getLhs())) {
                return true;
            }
            if (this.accessesText(((AbstractLogicalEvaluator)evaluator).getRhs())) {
                return true;
            }
        } else if (evaluator instanceof PredicatesEvaluator) {
            List<XPathExpressionEvaluator> evaluators = ((PredicatesEvaluator)evaluator).getEvaluators();
            for (XPathExpressionEvaluator pEvaluator : evaluators) {
                if (!this.accessesText(pEvaluator)) continue;
                return true;
            }
        }
        return false;
    }

    public <T extends XPathExpressionEvaluator> void getEvaluators(Class<T> evaluatorClass, List<T> evaluators) {
        this.getEvaluators(this.getPredicatesEvaluator(), evaluatorClass, evaluators);
    }

    private <T extends XPathExpressionEvaluator> void getEvaluators(XPathExpressionEvaluator evaluator, Class<T> evaluatorClass, List<XPathExpressionEvaluator> evaluators) {
        if (evaluator.getClass() == evaluatorClass) {
            evaluators.add(evaluator);
        }
        if (evaluator instanceof AbstractLogicalEvaluator) {
            this.getEvaluators(((AbstractLogicalEvaluator)evaluator).getLhs(), evaluatorClass, evaluators);
            this.getEvaluators(((AbstractLogicalEvaluator)evaluator).getRhs(), evaluatorClass, evaluators);
        } else if (evaluator instanceof PredicatesEvaluator) {
            List<XPathExpressionEvaluator> subEvaluators = ((PredicatesEvaluator)evaluator).getEvaluators();
            for (XPathExpressionEvaluator pEvaluator : subEvaluators) {
                this.getEvaluators(pEvaluator, evaluatorClass, evaluators);
            }
        }
    }

    private QName toQName(Step step, PredicatesEvaluatorBuilder evaluatorCompiler) throws SAXPathException {
        String nsPrefix = ((NameStep)step).getPrefix();
        String localPart = ((NameStep)step).getLocalName();
        if (nsPrefix != null && !nsPrefix.trim().equals("")) {
            if (evaluatorCompiler != null) {
                return new QName(evaluatorCompiler.getNamespace(nsPrefix), localPart, nsPrefix);
            }
            return new QName(null, localPart, nsPrefix);
        }
        return new QName(localPart);
    }

    public String toString() {
        XPathExpressionEvaluator evaluator;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getTargetElement());
        if (this.targetAttribute != null) {
            stringBuilder.append("{@").append(this.targetAttribute).append("}");
        }
        if ((evaluator = this.getPredicatesEvaluator()) != null) {
            stringBuilder.append(evaluator);
        }
        return stringBuilder.toString();
    }

    public static SelectorStep[] setNamespaces(SelectorStep[] steps, Properties namespaces) throws SAXPathException {
        AssertArgument.isNotNull((Object)steps, (String)"steps");
        AssertArgument.isNotNull((Object)namespaces, (String)"namespaces");
        for (int i = 0; i < steps.length; ++i) {
            SelectorStep step = steps[i];
            try {
                step.buildPredicatesEvaluator(namespaces);
            }
            catch (SAXPathException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SAXPathException("Error compiling PredicatesEvaluator.", (Throwable)e);
            }
            if (i >= steps.length - 1 || !step.accessesText()) continue;
            throw new SAXPathException("Unsupported XPath selector expression '" + step.getXPathExpression() + "'.  XPath 'text()' tokens are only supported in the last step.");
        }
        return steps;
    }

    public boolean isHashedAttribute() {
        return false;
    }
}

