/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.namespace.QName;
import org.jaxen.JaxenHandler;
import org.jaxen.expr.Expr;
import org.jaxen.expr.LocationPath;
import org.jaxen.expr.Step;
import org.jaxen.expr.XPathExpr;
import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathHandler;
import org.jaxen.saxpath.XPathReader;
import org.jaxen.saxpath.helpers.XPathReaderFactory;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.xpath.SelectorStep;

public class SelectorStepBuilder {
    private static SelectorStep[] SELECTOR_NONE_STEP;

    public static SelectorStep[] buildSteps(String selectorExpression) throws SAXPathException {
        if ("none".equals(selectorExpression)) {
            return SELECTOR_NONE_STEP;
        }
        return SelectorStepBuilder._buildSteps(selectorExpression);
    }

    private static SelectorStep[] _buildSteps(String selectorExpression) throws SAXPathException {
        AssertArgument.isNotNull((Object)selectorExpression, (String)"selectorExpression");
        String xpathExpression = SelectorStepBuilder.toXPathExpression(selectorExpression);
        XPathReader reader = XPathReaderFactory.createReader();
        JaxenHandler handler = new JaxenHandler();
        ArrayList<SelectorStep> selectorSteps = new ArrayList<SelectorStep>();
        boolean isRooted = false;
        boolean endsStarStar = false;
        if (xpathExpression.startsWith("/")) {
            isRooted = true;
        } else if (SelectorStepBuilder.isEncodedToken(xpathExpression)) {
            String[] tokens = xpathExpression.split("/");
            selectorSteps.add(new SelectorStep(tokens[0]));
            StringBuilder reconstructedExpression = new StringBuilder();
            for (int i = 1; i < tokens.length; ++i) {
                if (reconstructedExpression.length() > 0) {
                    reconstructedExpression.append('/');
                }
                reconstructedExpression.append(tokens[i]);
            }
            xpathExpression = reconstructedExpression.toString();
        }
        if (xpathExpression.endsWith("//")) {
            endsStarStar = true;
            xpathExpression = xpathExpression.substring(0, xpathExpression.length() - 2);
        }
        if (xpathExpression.trim().length() > 0) {
            reader.setXPathHandler((XPathHandler)handler);
            reader.parse(xpathExpression);
            XPathExpr xpath = handler.getXPathExpr();
            Expr expr = xpath.getRootExpr();
            if (!(expr instanceof LocationPath)) {
                throw new SAXPathException("Invalid XPath expression '" + xpathExpression + "'.  Selector must be a LocationPath expression. Is '" + expr.getText() + "'.");
            }
            LocationPath path = (LocationPath)expr;
            List steps = path.getSteps();
            for (int i = 0; i < steps.size(); ++i) {
                Step step = (Step)steps.get(i);
                try {
                    if (step.getAxis() == 9 && i < steps.size() - 1) {
                        throw new SAXPathException("Attribute axis steps are only supported at the end of the expression.  '" + step.getText() + "' is not at the end.");
                    }
                    if (step.getAxis() == 12) {
                        selectorSteps.add(new SelectorStep(xpathExpression, "**"));
                        continue;
                    }
                    if (step.getAxis() != 1 && step.getAxis() != 9) {
                        throw new SAXPathException("XPath step '" + step.getText() + "' not supported.");
                    }
                    if (i == steps.size() - 2) {
                        Step nextStep = (Step)steps.get(i + 1);
                        if (nextStep.getAxis() == 9) {
                            selectorSteps.add(new SelectorStep(xpathExpression, step, nextStep));
                            break;
                        }
                        selectorSteps.add(new SelectorStep(xpathExpression, step));
                        continue;
                    }
                    selectorSteps.add(new SelectorStep(xpathExpression, step));
                    continue;
                }
                catch (SAXPathException e) {
                    throw new SAXPathException("Error processing XPath selector expression '" + xpathExpression + "'.", (Throwable)e);
                }
                catch (Exception e) {
                    throw new SAXPathException("Error building step evaluator.", (Throwable)e);
                }
            }
        }
        if (isRooted) {
            if (selectorSteps.isEmpty()) {
                selectorSteps.add(new SelectorStep(xpathExpression, "#document"));
            } else {
                ((SelectorStep)selectorSteps.get(0)).setRooted(true);
            }
        }
        if (endsStarStar) {
            selectorSteps.add(new SelectorStep(xpathExpression, "**"));
        }
        return selectorSteps.toArray(new SelectorStep[0]);
    }

    private static boolean isEncodedToken(String xpathExpression) {
        if (xpathExpression.startsWith("#") && !xpathExpression.startsWith("#document")) {
            return true;
        }
        return xpathExpression.startsWith("$") && !xpathExpression.startsWith("$document");
    }

    public static SelectorStep[] buildSteps(String selectorExpression, Properties namespaces) throws SAXPathException {
        SelectorStep[] steps = SelectorStepBuilder.buildSteps(selectorExpression);
        return SelectorStep.setNamespaces(steps, namespaces);
    }

    public static String toString(SelectorStep[] steps) {
        AssertArgument.isNotNull((Object)steps, (String)"steps");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < steps.length; ++i) {
            if (steps[i].isRooted()) {
                stringBuilder.append("/");
            } else if (i > 0) {
                stringBuilder.append("/");
            }
            stringBuilder.append(steps[i]);
        }
        return stringBuilder.toString();
    }

    private static String toXPathExpression(String selectorExpression) {
        StringBuilder xpathExpressionBuilder = new StringBuilder();
        boolean normalize = true;
        for (int i = 0; i < selectorExpression.length(); ++i) {
            char character = selectorExpression.charAt(i);
            if (character == '[') {
                normalize = false;
            } else if (character == ']') {
                normalize = true;
            } else if (character == ' ' && normalize) {
                if (xpathExpressionBuilder.charAt(xpathExpressionBuilder.length() - 1) == '/') continue;
                xpathExpressionBuilder.append('/');
                continue;
            }
            xpathExpressionBuilder.append(character);
        }
        String xpathExpression = xpathExpressionBuilder.toString();
        if ((xpathExpression = xpathExpression.replace("$document", "#document")).equals("#document")) {
            xpathExpression = "/";
        }
        if (xpathExpression.startsWith("#document/")) {
            xpathExpression = xpathExpression.substring("#document".length());
        }
        xpathExpression = xpathExpression.replace("/**/", "//");
        xpathExpression = xpathExpression.replace("/**", "//");
        xpathExpression = xpathExpression.replace("**/", "//");
        return xpathExpression;
    }

    public static String[] toContextualSelector(SelectorStep[] selectorSteps) {
        String[] contextualSelector;
        String targetAttribute = SelectorStepBuilder.extractTargetAttribute(selectorSteps);
        if (targetAttribute != null) {
            contextualSelector = new String[selectorSteps.length + 1];
            contextualSelector[contextualSelector.length - 1] = "@" + targetAttribute;
        } else {
            contextualSelector = new String[selectorSteps.length];
        }
        for (int i = 0; i < selectorSteps.length; ++i) {
            contextualSelector[i] = selectorSteps[i].getTargetElement().getLocalPart();
        }
        return contextualSelector;
    }

    public static String extractTargetElement(SelectorStep[] selectorSteps) {
        return selectorSteps[selectorSteps.length - 1].getTargetElement().getLocalPart();
    }

    public static String extractTargetAttribute(SelectorStep[] selectorSteps) {
        QName targetAttribute = selectorSteps[selectorSteps.length - 1].getTargetAttribute();
        if (targetAttribute == null) {
            return null;
        }
        return targetAttribute.getLocalPart();
    }

    static {
        try {
            SELECTOR_NONE_STEP = SelectorStepBuilder._buildSteps("none");
        }
        catch (SAXPathException e) {
            throw new IllegalStateException("Unexpected exception while constructing the 'none' SelectorStep array.");
        }
    }
}

