/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.cdr.xpath.evaluators.equality;

import java.io.IOException;
import org.milyn.SmooksException;
import org.milyn.cdr.xpath.SelectorStep;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitBefore;

public class ElementIndexCounter
implements SAXVisitBefore {
    private SelectorStep selectorStep;

    public ElementIndexCounter(SelectorStep selectorStep) {
        this.selectorStep = selectorStep;
    }

    public SelectorStep getSelectorStep() {
        return this.selectorStep;
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        ElementIndex index = this.getElementIndex(element);
        if (index != null) {
            index.i++;
        }
    }

    protected int getCount(SAXElement element) {
        ElementIndex index = this.getElementIndex(element);
        if (index != null) {
            return index.i;
        }
        return 0;
    }

    private ElementIndex getElementIndex(SAXElement element) {
        SAXElement parent = element.getParent();
        if (parent != null) {
            ElementIndex index = (ElementIndex)parent.getCache(this);
            if (index == null) {
                index = new ElementIndex();
                parent.setCache(this, index);
            }
            return index;
        }
        return null;
    }

    private class ElementIndex {
        private int i = 0;

        private ElementIndex() {
        }
    }
}

