/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.util;

import freemarker.ext.dom.NodeModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.DOMModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FreeMarkerUtils {
    public static Map<String, Object> getMergedModel(ExecutionContext executionContext) {
        Map<String, Object> beans;
        Map<String, Object> model = beans = executionContext.getBeanContext().getBeanMap();
        DOMModel domModel = DOMModel.getModel(executionContext);
        if (!domModel.getModels().isEmpty()) {
            Map<String, ElementToNodeModel> elementToNodeModelMap = FreeMarkerUtils.getElementToNodeModelMap(executionContext);
            model = new HashMap<String, Object>();
            model.putAll(beans);
            Set<Map.Entry<String, Element>> models = domModel.getModels().entrySet();
            for (Map.Entry<String, Element> entry : models) {
                NodeModel nodeModel = FreeMarkerUtils.getNodeModel(entry.getKey(), entry.getValue(), elementToNodeModelMap);
                model.put(entry.getKey(), nodeModel);
            }
        }
        return model;
    }

    private static NodeModel getNodeModel(String key, Element element, Map<String, ElementToNodeModel> elementToNodeModelMap) {
        ElementToNodeModel elementToNodeModel = elementToNodeModelMap.get(key);
        if (elementToNodeModel == null) {
            elementToNodeModel = new ElementToNodeModel();
            elementToNodeModelMap.put(key, elementToNodeModel);
            elementToNodeModel.element = element;
            elementToNodeModel.nodeModel = NodeModel.wrap((Node)element);
        } else if (elementToNodeModel.element != element) {
            elementToNodeModel.element = element;
            elementToNodeModel.nodeModel = NodeModel.wrap((Node)element);
        }
        return elementToNodeModel.nodeModel;
    }

    private static Map<String, ElementToNodeModel> getElementToNodeModelMap(ExecutionContext executionContext) {
        HashMap map = (HashMap)executionContext.getAttribute(ElementToNodeModel.class);
        if (map == null) {
            map = new HashMap();
            executionContext.setAttribute(ElementToNodeModel.class, map);
        }
        return map;
    }

    private static class ElementToNodeModel {
        private Element element;
        private NodeModel nodeModel;

        private ElementToNodeModel() {
        }
    }
}

