/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.decoders;

import java.text.NumberFormat;
import java.text.ParseException;
import org.milyn.javabean.DataDecodeException;
import org.milyn.javabean.DecodeType;
import org.milyn.javabean.decoders.NumberDecoder;

@DecodeType(value={Float.class, float.class})
public class FloatDecoder
extends NumberDecoder {
    public Object decode(String data) throws DataDecodeException {
        NumberFormat format = this.getNumberFormat();
        if (format != null) {
            try {
                Number number = format.parse(data.trim());
                return Float.valueOf(number.floatValue());
            }
            catch (ParseException e) {
                throw new DataDecodeException("Failed to decode Float value '" + data + "' using NumberFormat instance " + format + ".", (Throwable)e);
            }
        }
        try {
            return Float.valueOf(Float.parseFloat(data.trim()));
        }
        catch (NumberFormatException e) {
            throw new DataDecodeException("Failed to decode float value '" + data + "'.", (Throwable)e);
        }
    }
}

