/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.milyn.Smooks;
import org.milyn.assertion.AssertArgument;
import org.milyn.cdr.SmooksResourceConfigurationList;
import org.milyn.container.ExecutionContext;
import org.milyn.event.ExecutionEventListener;
import org.milyn.event.report.HtmlReportGenerator;
import org.milyn.javabean.binding.model.Bean;
import org.milyn.javabean.binding.model.DataBinding;
import org.milyn.javabean.binding.model.WiredBinding;
import org.milyn.javabean.binding.model.get.GetterGraph;
import org.milyn.payload.JavaResult;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractBinding {
    private Smooks smooks;
    private String reportPath;
    private boolean allConfigsAdded = false;
    private boolean initialized = false;

    protected AbstractBinding() {
        this.smooks = new Smooks();
    }

    protected AbstractBinding(Smooks smooks) {
        this.smooks = smooks;
        this.allConfigsAdded = true;
    }

    public AbstractBinding add(String smooksConfigURI) throws IOException, SAXException {
        this.assertNotAllConfigsAdded();
        this.assertNotInitialized();
        this.smooks.addConfigurations(smooksConfigURI);
        return this;
    }

    public AbstractBinding add(InputStream smooksConfigStream) throws IOException, SAXException {
        this.assertNotAllConfigsAdded();
        this.assertNotInitialized();
        this.smooks.addConfigurations(smooksConfigStream);
        return this;
    }

    public AbstractBinding intiailize() {
        this.assertNotInitialized();
        this.smooks.createExecutionContext();
        this.allConfigsAdded = true;
        this.initialized = true;
        return this;
    }

    public Smooks getSmooks() {
        return this.smooks;
    }

    public AbstractBinding setReportPath(String reportPath) {
        this.reportPath = reportPath;
        return this;
    }

    protected <T> T bind(Source inputSource, Class<T> toType) throws IOException {
        AssertArgument.isNotNull((Object)inputSource, (String)"inputSource");
        AssertArgument.isNotNull(toType, (String)"toType");
        this.assertInitialized();
        JavaResult javaResult = new JavaResult();
        ExecutionContext executionContext = this.smooks.createExecutionContext();
        if (this.reportPath != null) {
            executionContext.setEventListener((ExecutionEventListener)new HtmlReportGenerator(this.reportPath));
        }
        this.smooks.filterSource(executionContext, inputSource, new Result[]{javaResult});
        return (T)javaResult.getBean(toType);
    }

    protected SmooksResourceConfigurationList getUserDefinedResourceList() {
        return this.smooks.getApplicationContext().getStore().getUserDefinedResourceList();
    }

    protected GetterGraph constructContextualGetter(DataBinding binding) {
        GetterGraph contextualGetter = new GetterGraph();
        contextualGetter.add(binding);
        this.addToContextualGetter(contextualGetter, binding.getParentBean());
        return contextualGetter;
    }

    protected GetterGraph constructContextualGetter(Bean bean) {
        return this.addToContextualGetter(new GetterGraph(), bean);
    }

    private GetterGraph addToContextualGetter(GetterGraph contextualGetter, Bean bean) {
        Bean theBean = bean;
        while (theBean != null) {
            Bean parentBean = theBean.getWiredInto();
            if (parentBean != null) {
                if (parentBean.isCollection()) {
                    Bean wiredInto = parentBean.getWiredInto();
                    if (wiredInto == null) break;
                    contextualGetter.setContextObjectName(theBean.getBeanId());
                    break;
                }
                WiredBinding binding = parentBean.getWiredBinding(theBean);
                if (binding == null) {
                    throw new IllegalStateException("Failed to locate a wiring of theBean '" + theBean + "' on theBean '" + parentBean + "'.");
                }
                contextualGetter.add(parentBean, binding.getProperty());
            }
            theBean = parentBean;
        }
        return contextualGetter;
    }

    protected void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException("Illegal call to method before instance is initialized.  Must call the 'initialize' method first.");
        }
    }

    protected void assertNotAllConfigsAdded() {
        if (this.allConfigsAdded) {
            throw new IllegalStateException("Illegal call to method after all configurations have been added.");
        }
    }

    protected void assertNotInitialized() {
        if (this.initialized) {
            throw new IllegalStateException("Illegal call to method after instance is initialized.");
        }
    }
}

