/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.BeanIdStore;
import org.milyn.javabean.repository.BeanId;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.ObjectStore;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('insertBefore') && parameters.insertBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('insertBefore') || parameters.insertBefore.value != 'true'")
@VisitBeforeReport(summary="Inserting bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityInserter.html")
@VisitAfterReport(summary="Inserting bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityInserter.html")
public class EntityInserter
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Consumer,
Producer {
    private static Log logger = LogFactory.getLog(EntityInserter.class);
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="insertedBeanId", use=ConfigParam.Use.OPTIONAL)
    private String insertedBeanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @AppContext
    private ApplicationContext appContext;
    private ObjectStore objectStore;
    private BeanId beanId;
    private BeanId insertedBeanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        BeanIdStore beanIdStore = this.appContext.getBeanIdStore();
        this.beanId = beanIdStore.register(this.beanIdName);
        if (this.insertedBeanIdName != null) {
            this.insertedBeanId = beanIdStore.register(this.insertedBeanIdName);
        }
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public Set<? extends Object> getProducts() {
        if (this.insertedBeanIdName == null) {
            return Collections.emptySet();
        }
        return CollectionsUtil.toSet((Object[])new String[]{this.insertedBeanIdName});
    }

    public boolean consumes(Object object) {
        return object.equals(this.beanIdName);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.insert(executionContext, new Fragment(element));
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.insert(executionContext, new Fragment(element));
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.insert(executionContext, new Fragment(element));
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.insert(executionContext, new Fragment(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insert(ExecutionContext executionContext, Fragment source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Inserting bean under BeanId '" + this.beanIdName + "' with DAO '" + this.daoName + "'."));
        }
        BeanContext beanRepository = executionContext.getBeanContext();
        Object bean = beanRepository.getBean(this.beanId);
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            Object result;
            dao = this.daoName == null ? emr.getDefaultDao() : emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO '" + this.daoName + "'");
            }
            DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, this.objectStore);
            Object object = result = this.name == null ? daoInvoker.insert(bean) : daoInvoker.insert(this.name, bean);
            if (this.insertedBeanId != null) {
                if (result == null) {
                    result = bean;
                }
                beanRepository.addBean(this.insertedBeanId, result, source);
            } else if (result != null && bean != result) {
                beanRepository.changeBean(this.beanId, bean, source);
            }
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }
}

