/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.ObjectStore;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.w3c.dom.Element;

@VisitBeforeIf(condition="parameters.containsKey('flushBefore') && parameters.flushBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('flushBefore') || parameters.flushBefore.value != 'true'")
@VisitBeforeReport(summary="Flushing <#if !resource.parameters.dao??>default </#if>DAO<#if resource.parameters.dao??> '${resource.parameters.dao}'</#if>.", detailTemplate="reporting/DaoFlusher.html")
@VisitAfterReport(summary="Flushing <#if !resource.parameters.dao??>default </#if>DAO<#if resource.parameters.dao??> '${resource.parameters.dao}'</#if>.", detailTemplate="reporting/DaoFlusher.html")
public class DaoFlusher
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter {
    private static Log logger = LogFactory.getLog(DaoFlusher.class);
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @AppContext
    private ApplicationContext appContext;
    private ApplicationContextObjectStore objectStore;

    @Initialize
    public void initialize() {
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.flush(executionContext);
    }

    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.flush(executionContext);
    }

    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.flush(executionContext);
    }

    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.flush(executionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(ExecutionContext executionContext) {
        if (logger.isDebugEnabled()) {
            String msg = "Flushing org.milyn.persistence.test.dao";
            if (this.daoName != null) {
                msg = msg + " with name '" + this.daoName + "'";
            }
            msg = msg + ".";
            logger.debug((Object)msg);
        }
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            dao = this.daoName == null ? emr.getDefaultDao() : emr.getDao(this.daoName);
            if (dao == null) {
                throw new IllegalStateException("The DAO register returned null while getting the DAO [" + this.daoName + "]");
            }
            this.flush(dao);
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }

    private void flush(Object dao) {
        DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, (ObjectStore)this.objectStore);
        daoInvoker.flush();
    }
}

