/*
 * Decompiled with CFR 0.152.
 */
package org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.io.Bits;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

public class BSONDecoder {
    private Input _in;
    private BSONCallback _callback;
    private byte[] _random = new byte[1024];
    private PoolOutputBuffer _stringBuffer = new PoolOutputBuffer();

    public BSONObject readObject(byte[] b) {
        try {
            return this.readObject(new ByteArrayInputStream(b));
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        BasicBSONCallback c = new BasicBSONCallback();
        this.decode(in, (BSONCallback)c);
        return (BSONObject)c.get();
    }

    public int decode(byte[] b, BSONCallback callback) {
        try {
            return this.decode(new Input(new ByteArrayInputStream(b)), callback);
        }
        catch (IOException ioe) {
            throw new RuntimeException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        return this.decode(new Input(in), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int decode(Input in, BSONCallback callback) throws IOException {
        if (this._in != null || this._callback != null) {
            throw new IllegalStateException("not ready");
        }
        this._in = in;
        this._callback = callback;
        try {
            int n = this.decode();
            return n;
        }
        finally {
            this._in = null;
            this._callback = null;
        }
    }

    int decode() throws IOException {
        int start = this._in._read;
        int len = this._in.readInt();
        this._callback.objectStart();
        while (this.decodeElement()) {
        }
        this._callback.objectDone();
        int read = this._in._read - start;
        if (read != len) {
            // empty if block
        }
        return len;
    }

    boolean decodeElement() throws IOException {
        byte type = this._in.read();
        if (type == 0) {
            return false;
        }
        String name = this._in.readCStr();
        switch (type) {
            case 10: {
                this._callback.gotNull(name);
                break;
            }
            case 6: {
                this._callback.gotUndefined(name);
                break;
            }
            case 8: {
                this._callback.gotBoolean(name, this._in.read() > 0);
                break;
            }
            case 1: {
                this._callback.gotDouble(name, this._in.readDouble());
                break;
            }
            case 16: {
                this._callback.gotInt(name, this._in.readInt());
                break;
            }
            case 18: {
                this._callback.gotLong(name, this._in.readLong());
                break;
            }
            case 14: {
                this._callback.gotSymbol(name, this._in.readUTF8String());
                break;
            }
            case 2: {
                this._callback.gotString(name, this._in.readUTF8String());
                break;
            }
            case 7: {
                this._callback.gotObjectId(name, new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt()));
                break;
            }
            case 12: {
                this._in.readInt();
                String ns = this._in.readCStr();
                ObjectId theOID = new ObjectId(this._in.readInt(), this._in.readInt(), this._in.readInt());
                this._callback.gotDBRef(name, ns, theOID);
                break;
            }
            case 9: {
                this._callback.gotDate(name, this._in.readLong());
                break;
            }
            case 11: {
                this._callback.gotRegex(name, this._in.readCStr(), this._in.readCStr());
                break;
            }
            case 5: {
                this._binary(name);
                break;
            }
            case 13: {
                this._callback.gotCode(name, this._in.readUTF8String());
                break;
            }
            case 15: {
                this._in.readInt();
                this._callback.gotCodeWScope(name, this._in.readUTF8String(), this._readBasicObject());
                break;
            }
            case 4: {
                this._in.readInt();
                this._callback.arrayStart(name);
                while (this.decodeElement()) {
                }
                this._callback.arrayDone();
                break;
            }
            case 3: {
                this._in.readInt();
                this._callback.objectStart(name);
                while (this.decodeElement()) {
                }
                this._callback.objectDone();
                break;
            }
            case 17: {
                int i = this._in.readInt();
                int time = this._in.readInt();
                this._callback.gotTimestamp(name, time, i);
                break;
            }
            case -1: {
                this._callback.gotMinKey(name);
                break;
            }
            case 127: {
                this._callback.gotMaxKey(name);
                break;
            }
            default: {
                throw new UnsupportedOperationException("BSONDecoder doesn't understand type : " + type + " name: " + name);
            }
        }
        return true;
    }

    void _binary(String name) throws IOException {
        int totalLen = this._in.readInt();
        byte bType = this._in.read();
        switch (bType) {
            case 0: {
                byte[] data = new byte[totalLen];
                this._in.fill(data);
                this._callback.gotBinaryArray(name, data);
                return;
            }
            case 2: {
                int len = this._in.readInt();
                if (len + 4 != totalLen) {
                    throw new IllegalArgumentException("bad data size subtype 2 len: " + len + " totalLen: " + totalLen);
                }
                byte[] data = new byte[len];
                this._in.fill(data);
                this._callback.gotBinaryArray(name, data);
                return;
            }
            case 3: {
                if (totalLen != 16) {
                    throw new IllegalArgumentException("bad data size subtype 3 len: " + totalLen + " != 16");
                }
                long part1 = this._in.readLong();
                long part2 = this._in.readLong();
                this._callback.gotUUID(name, part1, part2);
                return;
            }
        }
        byte[] data = new byte[totalLen];
        this._in.fill(data);
        this._callback.gotBinary(name, bType, data);
    }

    Object _readBasicObject() throws IOException {
        BSONCallback _basic;
        this._in.readInt();
        BSONCallback save = this._callback;
        this._callback = _basic = this._callback.createBSONCallback();
        _basic.reset();
        _basic.objectStart(false);
        while (this.decodeElement()) {
        }
        this._callback = save;
        return _basic.get();
    }

    class Input {
        int _read;
        final InputStream _in;

        Input(InputStream in) {
            this._in = in;
            this._read = 0;
        }

        int readInt() throws IOException {
            this._read += 4;
            return Bits.readInt(this._in);
        }

        long readLong() throws IOException {
            this._read += 8;
            return Bits.readLong(this._in);
        }

        double readDouble() throws IOException {
            return Double.longBitsToDouble(this.readLong());
        }

        byte read() throws IOException {
            ++this._read;
            return (byte)(this._in.read() & 0xFF);
        }

        void fill(byte[] b) throws IOException {
            this.fill(b, b.length);
        }

        void fill(byte[] b, int len) throws IOException {
            int off = 0;
            while (len > 0) {
                int x = this._in.read(b, off, len);
                this._read += x;
                off += x;
                len -= x;
            }
        }

        String readCStr() throws IOException {
            byte b;
            BSONDecoder.this._stringBuffer.reset();
            while ((b = this.read()) != 0) {
                BSONDecoder.this._stringBuffer.write(b);
            }
            String out = null;
            try {
                out = BSONDecoder.this._stringBuffer.asString("UTF-8");
            }
            catch (UnsupportedOperationException e) {
                throw new RuntimeException("impossible", e);
            }
            BSONDecoder.this._stringBuffer.reset();
            return out;
        }

        String readUTF8String() throws IOException {
            int size = this.readInt();
            if (size < 0 || size > 0x300000) {
                throw new RuntimeException("bad string size: " + size);
            }
            byte[] b = size < BSONDecoder.this._random.length ? BSONDecoder.this._random : new byte[size];
            this.fill(b, size);
            try {
                return new String(b, 0, size - 1, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new RuntimeException("impossible", uee);
            }
        }
    }
}

