/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Sorts {
    private Sorts() {
    }

    public static Bson ascending(String ... fieldNames) {
        return Sorts.ascending(Arrays.asList(fieldNames));
    }

    public static Bson ascending(List<String> fieldNames) {
        Assertions.notNull("fieldNames", fieldNames);
        return Sorts.orderBy(fieldNames, (BsonValue)new BsonInt32(1));
    }

    public static Bson descending(String ... fieldNames) {
        return Sorts.descending(Arrays.asList(fieldNames));
    }

    public static Bson descending(List<String> fieldNames) {
        Assertions.notNull("fieldNames", fieldNames);
        return Sorts.orderBy(fieldNames, (BsonValue)new BsonInt32(-1));
    }

    public static Bson metaTextScore(String fieldName) {
        return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$meta", (BsonValue)new BsonString("textScore")));
    }

    public static Bson orderBy(Bson ... sorts) {
        return Sorts.orderBy(Arrays.asList(sorts));
    }

    public static Bson orderBy(final List<Bson> sorts) {
        Assertions.notNull("sorts", sorts);
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument combinedDocument = new BsonDocument();
                for (Bson sort : sorts) {
                    BsonDocument sortDocument = sort.toBsonDocument(documentClass, codecRegistry);
                    for (String key : sortDocument.keySet()) {
                        combinedDocument.append(key, sortDocument.get((Object)key));
                    }
                }
                return combinedDocument;
            }
        };
    }

    private static Bson orderBy(List<String> fieldNames, BsonValue value) {
        BsonDocument document = new BsonDocument();
        for (String fieldName : fieldNames) {
            document.append(fieldName, value);
        }
        return document;
    }
}

