/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.BuildersHelper;
import com.mongodb.client.model.TextSearchOptions;
import com.mongodb.client.model.geojson.Geometry;
import com.mongodb.client.model.geojson.Point;
import com.mongodb.lang.Nullable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Filters {
    private Filters() {
    }

    public static <TItem> Bson eq(@Nullable TItem value) {
        return Filters.eq("_id", value);
    }

    public static <TItem> Bson eq(String fieldName, @Nullable TItem value) {
        return new SimpleEncodingFilter<TItem>(fieldName, value);
    }

    public static <TItem> Bson ne(String fieldName, @Nullable TItem value) {
        return new OperatorFilter<TItem>("$ne", fieldName, value);
    }

    public static <TItem> Bson gt(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$gt", fieldName, value);
    }

    public static <TItem> Bson lt(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$lt", fieldName, value);
    }

    public static <TItem> Bson gte(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$gte", fieldName, value);
    }

    public static <TItem> Bson lte(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$lte", fieldName, value);
    }

    @SafeVarargs
    public static <TItem> Bson in(String fieldName, TItem ... values) {
        return Filters.in(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson in(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$in", values);
    }

    @SafeVarargs
    public static <TItem> Bson nin(String fieldName, TItem ... values) {
        return Filters.nin(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson nin(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$nin", values);
    }

    public static Bson and(Iterable<Bson> filters) {
        return new AndFilter(filters);
    }

    public static Bson and(Bson ... filters) {
        return Filters.and(Arrays.asList(filters));
    }

    public static Bson or(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.OR, filters);
    }

    public static Bson or(Bson ... filters) {
        return Filters.or(Arrays.asList(filters));
    }

    public static Bson not(Bson filter) {
        return new NotFilter(filter);
    }

    public static Bson nor(Bson ... filters) {
        return Filters.nor(Arrays.asList(filters));
    }

    public static Bson nor(Iterable<Bson> filters) {
        return new OrNorFilter(OrNorFilter.Operator.NOR, filters);
    }

    public static Bson exists(String fieldName) {
        return Filters.exists(fieldName, true);
    }

    public static Bson exists(String fieldName, boolean exists) {
        return new OperatorFilter<BsonBoolean>("$exists", fieldName, BsonBoolean.valueOf((boolean)exists));
    }

    public static Bson type(String fieldName, BsonType type) {
        return new OperatorFilter<BsonInt32>("$type", fieldName, new BsonInt32(type.getValue()));
    }

    public static Bson type(String fieldName, String type) {
        return new OperatorFilter<BsonString>("$type", fieldName, new BsonString(type));
    }

    public static Bson mod(String fieldName, long divisor, long remainder) {
        return new OperatorFilter<BsonArray>("$mod", fieldName, new BsonArray(Arrays.asList(new BsonInt64(divisor), new BsonInt64(remainder))));
    }

    public static Bson regex(String fieldName, String pattern) {
        return Filters.regex(fieldName, pattern, null);
    }

    public static Bson regex(String fieldName, String pattern, @Nullable String options) {
        Assertions.notNull("pattern", pattern);
        return new SimpleFilter(fieldName, (BsonValue)new BsonRegularExpression(pattern, options));
    }

    public static Bson regex(String fieldName, Pattern pattern) {
        Assertions.notNull("pattern", pattern);
        return new SimpleEncodingFilter<Pattern>(fieldName, pattern);
    }

    public static Bson text(String search) {
        Assertions.notNull("search", search);
        return Filters.text(search, new TextSearchOptions());
    }

    public static Bson text(String search, TextSearchOptions textSearchOptions) {
        Assertions.notNull("search", search);
        Assertions.notNull("textSearchOptions", textSearchOptions);
        return new TextFilter(search, textSearchOptions);
    }

    public static Bson where(String javaScriptExpression) {
        Assertions.notNull("javaScriptExpression", javaScriptExpression);
        return new BsonDocument("$where", (BsonValue)new BsonString(javaScriptExpression));
    }

    public static <TExpression> Bson expr(TExpression expression) {
        return new SimpleEncodingFilter<TExpression>("$expr", expression);
    }

    @SafeVarargs
    public static <TItem> Bson all(String fieldName, TItem ... values) {
        return Filters.all(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson all(String fieldName, Iterable<TItem> values) {
        return new IterableOperatorFilter<TItem>(fieldName, "$all", values);
    }

    public static Bson elemMatch(final String fieldName, final Bson filter) {
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$elemMatch", (BsonValue)filter.toBsonDocument(documentClass, codecRegistry)));
            }
        };
    }

    public static Bson size(String fieldName, int size) {
        return new OperatorFilter<Integer>("$size", fieldName, size);
    }

    public static Bson bitsAllClear(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllClear", fieldName, bitmask);
    }

    public static Bson bitsAllSet(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAllSet", fieldName, bitmask);
    }

    public static Bson bitsAnyClear(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnyClear", fieldName, bitmask);
    }

    public static Bson bitsAnySet(String fieldName, long bitmask) {
        return new OperatorFilter<Long>("$bitsAnySet", fieldName, bitmask);
    }

    public static Bson geoWithin(String fieldName, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoWithin", fieldName, geometry);
    }

    public static Bson geoWithin(String fieldName, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoWithin", fieldName, geometry);
    }

    public static Bson geoWithinBox(String fieldName, double lowerLeftX, double lowerLeftY, double upperRightX, double upperRightY) {
        BsonDocument box = new BsonDocument("$box", (BsonValue)new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(lowerLeftX), new BsonDouble(lowerLeftY))), new BsonArray(Arrays.asList(new BsonDouble(upperRightX), new BsonDouble(upperRightY))))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, box);
    }

    public static Bson geoWithinPolygon(String fieldName, List<List<Double>> points) {
        BsonArray pointsArray = new BsonArray();
        for (List<Double> point : points) {
            pointsArray.add((BsonValue)new BsonArray(Arrays.asList(new BsonDouble(point.get(0).doubleValue()), new BsonDouble(point.get(1).doubleValue()))));
        }
        BsonDocument polygon = new BsonDocument("$polygon", (BsonValue)pointsArray);
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, polygon);
    }

    public static Bson geoWithinCenter(String fieldName, double x, double y, double radius) {
        BsonDocument center = new BsonDocument("$center", (BsonValue)new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, center);
    }

    public static Bson geoWithinCenterSphere(String fieldName, double x, double y, double radius) {
        BsonDocument centerSphere = new BsonDocument("$centerSphere", (BsonValue)new BsonArray(Arrays.asList(new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))), new BsonDouble(radius))));
        return new OperatorFilter<BsonDocument>("$geoWithin", fieldName, centerSphere);
    }

    public static Bson geoIntersects(String fieldName, Bson geometry) {
        return new GeometryOperatorFilter<Bson>("$geoIntersects", fieldName, geometry);
    }

    public static Bson geoIntersects(String fieldName, Geometry geometry) {
        return new GeometryOperatorFilter<Geometry>("$geoIntersects", fieldName, geometry);
    }

    public static Bson near(String fieldName, Point geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return new GeometryOperatorFilter<Point>("$near", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName, Bson geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$near", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson near(String fieldName, double x, double y, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return Filters.createNearFilterDocument(fieldName, x, y, maxDistance, minDistance, "$near");
    }

    public static Bson nearSphere(String fieldName, Point geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return new GeometryOperatorFilter<Point>("$nearSphere", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName, Bson geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return new GeometryOperatorFilter<Bson>("$nearSphere", fieldName, geometry, maxDistance, minDistance);
    }

    public static Bson nearSphere(String fieldName, double x, double y, @Nullable Double maxDistance, @Nullable Double minDistance) {
        return Filters.createNearFilterDocument(fieldName, x, y, maxDistance, minDistance, "$nearSphere");
    }

    public static Bson jsonSchema(Bson schema) {
        return new SimpleEncodingFilter<Bson>("$jsonSchema", schema);
    }

    private static Bson createNearFilterDocument(String fieldName, double x, double y, @Nullable Double maxDistance, @Nullable Double minDistance, String operator) {
        BsonDocument nearFilter = new BsonDocument(operator, (BsonValue)new BsonArray(Arrays.asList(new BsonDouble(x), new BsonDouble(y))));
        if (maxDistance != null) {
            nearFilter.append("$maxDistance", (BsonValue)new BsonDouble(maxDistance.doubleValue()));
        }
        if (minDistance != null) {
            nearFilter.append("$minDistance", (BsonValue)new BsonDouble(minDistance.doubleValue()));
        }
        return new BsonDocument(fieldName, (BsonValue)nearFilter);
    }

    private static String operatorFilterToString(String fieldName, String operator, Object value) {
        return "Operator Filter{fieldName='" + fieldName + '\'' + ", operator='" + operator + '\'' + ", value=" + value + '}';
    }

    private static class TextFilter
    implements Bson {
        private final String search;
        private final TextSearchOptions textSearchOptions;

        TextFilter(String search, TextSearchOptions textSearchOptions) {
            this.search = search;
            this.textSearchOptions = textSearchOptions;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            Boolean diacriticSensitive;
            Boolean caseSensitive;
            BsonDocument searchDocument = new BsonDocument("$search", (BsonValue)new BsonString(this.search));
            String language = this.textSearchOptions.getLanguage();
            if (language != null) {
                searchDocument.put("$language", (BsonValue)new BsonString(language));
            }
            if ((caseSensitive = this.textSearchOptions.getCaseSensitive()) != null) {
                searchDocument.put("$caseSensitive", (BsonValue)BsonBoolean.valueOf((boolean)caseSensitive));
            }
            if ((diacriticSensitive = this.textSearchOptions.getDiacriticSensitive()) != null) {
                searchDocument.put("$diacriticSensitive", (BsonValue)BsonBoolean.valueOf((boolean)diacriticSensitive));
            }
            return new BsonDocument("$text", (BsonValue)searchDocument);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TextFilter that = (TextFilter)o;
            if (this.search != null ? !this.search.equals(that.search) : that.search != null) {
                return false;
            }
            return this.textSearchOptions != null ? this.textSearchOptions.equals(that.textSearchOptions) : that.textSearchOptions == null;
        }

        public int hashCode() {
            int result = this.search != null ? this.search.hashCode() : 0;
            result = 31 * result + (this.textSearchOptions != null ? this.textSearchOptions.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Text Filter{search='" + this.search + '\'' + ", textSearchOptions=" + this.textSearchOptions + '}';
        }
    }

    private static class GeometryOperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem geometry;
        private final Double maxDistance;
        private final Double minDistance;

        GeometryOperatorFilter(String operatorName, String fieldName, TItem geometry) {
            this(operatorName, fieldName, geometry, null, null);
        }

        GeometryOperatorFilter(String operatorName, String fieldName, TItem geometry, @Nullable Double maxDistance, @Nullable Double minDistance) {
            this.operatorName = operatorName;
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.geometry = Assertions.notNull("geometry", geometry);
            this.maxDistance = maxDistance;
            this.minDistance = minDistance;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            writer.writeStartDocument();
            writer.writeName("$geometry");
            BuildersHelper.encodeValue(writer, this.geometry, codecRegistry);
            if (this.maxDistance != null) {
                writer.writeDouble("$maxDistance", this.maxDistance.doubleValue());
            }
            if (this.minDistance != null) {
                writer.writeDouble("$minDistance", this.minDistance.doubleValue());
            }
            writer.writeEndDocument();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GeometryOperatorFilter that = (GeometryOperatorFilter)o;
            if (this.operatorName != null ? !this.operatorName.equals(that.operatorName) : that.operatorName != null) {
                return false;
            }
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            if (!this.geometry.equals(that.geometry)) {
                return false;
            }
            if (this.maxDistance != null ? !this.maxDistance.equals(that.maxDistance) : that.maxDistance != null) {
                return false;
            }
            return this.minDistance != null ? this.minDistance.equals(that.minDistance) : that.minDistance == null;
        }

        public int hashCode() {
            int result = this.operatorName != null ? this.operatorName.hashCode() : 0;
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + this.geometry.hashCode();
            result = 31 * result + (this.maxDistance != null ? this.maxDistance.hashCode() : 0);
            result = 31 * result + (this.minDistance != null ? this.minDistance.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Geometry Operator Filter{fieldName='" + this.fieldName + '\'' + ", operator='" + this.operatorName + '\'' + ", geometry=" + this.geometry + ", maxDistance=" + this.maxDistance + ", minDistance=" + this.minDistance + '}';
        }
    }

    private static class NotFilter
    implements Bson {
        private static final Set<String> DBREF_KEYS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id")));
        private static final Set<String> DBREF_KEYS_WITH_DB = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("$ref", "$id", "$db")));
        private final Bson filter;

        NotFilter(Bson filter) {
            this.filter = Assertions.notNull("filter", filter);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument filterDocument = this.filter.toBsonDocument(documentClass, codecRegistry);
            if (filterDocument.size() == 1) {
                Map.Entry entry = (Map.Entry)filterDocument.entrySet().iterator().next();
                return this.createFilter((String)entry.getKey(), (BsonValue)entry.getValue());
            }
            BsonArray values = new BsonArray();
            for (Map.Entry docs : filterDocument.entrySet()) {
                values.add((BsonValue)new BsonDocument((String)docs.getKey(), (BsonValue)docs.getValue()));
            }
            return this.createFilter("$and", (BsonValue)values);
        }

        private boolean containsOperator(BsonDocument value) {
            Set keys = value.keySet();
            if (keys.equals(DBREF_KEYS) || keys.equals(DBREF_KEYS_WITH_DB)) {
                return false;
            }
            for (String key : keys) {
                if (!key.startsWith("$")) continue;
                return true;
            }
            return false;
        }

        private BsonDocument createFilter(String fieldName, BsonValue value) {
            if (fieldName.startsWith("$")) {
                return new BsonDocument("$not", (BsonValue)new BsonDocument(fieldName, value));
            }
            if (value.isDocument() && this.containsOperator(value.asDocument()) || value.isRegularExpression()) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$not", value));
            }
            return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$not", (BsonValue)new BsonDocument("$eq", value)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NotFilter notFilter = (NotFilter)o;
            return this.filter.equals(notFilter.filter);
        }

        public int hashCode() {
            return this.filter.hashCode();
        }

        public String toString() {
            return "Not Filter{filter=" + this.filter + '}';
        }
    }

    private static class SimpleEncodingFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;

        SimpleEncodingFilter(String fieldName, @Nullable TItem value) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleEncodingFilter that = (SimpleEncodingFilter)o;
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "Filter{fieldName='" + this.fieldName + '\'' + ", value=" + this.value + '}';
        }
    }

    private static class IterableOperatorFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final String operatorName;
        private final Iterable<TItem> values;

        IterableOperatorFilter(String fieldName, String operatorName, Iterable<TItem> values) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.values = Assertions.notNull("values", values);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            writer.writeStartArray();
            for (TItem value : this.values) {
                BuildersHelper.encodeValue(writer, value, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IterableOperatorFilter that = (IterableOperatorFilter)o;
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            if (!this.operatorName.equals(that.operatorName)) {
                return false;
            }
            return this.values.equals(that.values);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.operatorName.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.values);
        }
    }

    private static class OrNorFilter
    implements Bson {
        private final Operator operator;
        private final Iterable<Bson> filters;

        OrNorFilter(Operator operator, Iterable<Bson> filters) {
            this.operator = Assertions.notNull("operator", operator);
            this.filters = Assertions.notNull("filters", filters);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument orRenderable = new BsonDocument();
            BsonArray filtersArray = new BsonArray();
            for (Bson filter : this.filters) {
                filtersArray.add((BsonValue)filter.toBsonDocument(documentClass, codecRegistry));
            }
            orRenderable.put(this.operator.name, (BsonValue)filtersArray);
            return orRenderable;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OrNorFilter that = (OrNorFilter)o;
            if (this.operator != that.operator) {
                return false;
            }
            return this.filters.equals(that.filters);
        }

        public int hashCode() {
            int result = this.operator.hashCode();
            result = 31 * result + this.filters.hashCode();
            return result;
        }

        public String toString() {
            return this.operator.toStringName + " Filter{filters=" + this.filters + '}';
        }

        private static enum Operator {
            OR("$or", "Or"),
            NOR("$nor", "Nor");

            private final String name;
            private final String toStringName;

            private Operator(String name, String toStringName) {
                this.name = name;
                this.toStringName = toStringName;
            }
        }
    }

    private static class AndFilter
    implements Bson {
        private final Iterable<Bson> filters;

        AndFilter(Iterable<Bson> filters) {
            this.filters = Assertions.notNull("filters", filters);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonArray clauses = new BsonArray();
            for (Bson filter : this.filters) {
                clauses.add((BsonValue)filter.toBsonDocument(documentClass, codecRegistry));
            }
            return new BsonDocument("$and", (BsonValue)clauses);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AndFilter andFilter = (AndFilter)o;
            return this.filters.equals(andFilter.filters);
        }

        public int hashCode() {
            return this.filters.hashCode();
        }

        public String toString() {
            return "And Filter{filters=" + this.filters + '}';
        }
    }

    private static final class OperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem value;

        OperatorFilter(String operatorName, String fieldName, @Nullable TItem value) {
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            BuildersHelper.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorFilter that = (OperatorFilter)o;
            if (!this.operatorName.equals(that.operatorName)) {
                return false;
            }
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            return this.value != null ? this.value.equals(that.value) : that.value == null;
        }

        public int hashCode() {
            int result = this.operatorName.hashCode();
            result = 31 * result + this.fieldName.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, this.operatorName, this.value);
        }
    }

    private static final class SimpleFilter
    implements Bson {
        private final String fieldName;
        private final BsonValue value;

        private SimpleFilter(String fieldName, BsonValue value) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = Assertions.notNull("value", value);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleFilter that = (SimpleFilter)o;
            if (!this.fieldName.equals(that.fieldName)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.fieldName.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return Filters.operatorFilterToString(this.fieldName, "$eq", this.value);
        }
    }
}

