/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.MongoInternalException;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.internal.connection.SslHelper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketOption;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import jdk.net.ExtendedSocketOptions;

final class SocketStreamHelper {
    private static final String TCP_KEEPIDLE = "TCP_KEEPIDLE";
    private static final int TCP_KEEPIDLE_DURATION = 120;
    private static final String TCP_KEEPCOUNT = "TCP_KEEPCOUNT";
    private static final int TCP_KEEPCOUNT_LIMIT = 9;
    private static final String TCP_KEEPINTERVAL = "TCP_KEEPINTERVAL";
    private static final int TCP_KEEPINTERVAL_DURATION = 10;

    static void initialize(Socket socket, InetSocketAddress inetSocketAddress, SocketSettings settings, SslSettings sslSettings) throws IOException {
        socket.setTcpNoDelay(true);
        socket.setSoTimeout(settings.getReadTimeout(TimeUnit.MILLISECONDS));
        socket.setKeepAlive(true);
        SocketStreamHelper.setExtendedSocketOptions(socket);
        if (settings.getReceiveBufferSize() > 0) {
            socket.setReceiveBufferSize(settings.getReceiveBufferSize());
        }
        if (settings.getSendBufferSize() > 0) {
            socket.setSendBufferSize(settings.getSendBufferSize());
        }
        if (sslSettings.isEnabled() || socket instanceof SSLSocket) {
            if (!(socket instanceof SSLSocket)) {
                throw new MongoInternalException("SSL is enabled but the socket is not an instance of javax.net.ssl.SSLSocket");
            }
            SSLSocket sslSocket = (SSLSocket)socket;
            SSLParameters sslParameters = sslSocket.getSSLParameters();
            if (sslParameters == null) {
                sslParameters = new SSLParameters();
            }
            SslHelper.enableSni(inetSocketAddress.getHostName(), sslParameters);
            if (!sslSettings.isInvalidHostNameAllowed()) {
                SslHelper.enableHostNameVerification(sslParameters);
            }
            sslSocket.setSSLParameters(sslParameters);
        }
        socket.connect(inetSocketAddress, settings.getConnectTimeout(TimeUnit.MILLISECONDS));
    }

    private static void setExtendedSocketOptions(Socket socket) {
        if (Arrays.stream(ExtendedSocketOptions.class.getDeclaredFields()).anyMatch(f -> f.getName().equals(TCP_KEEPCOUNT))) {
            try {
                Method setOptionMethod = Socket.class.getMethod("setOption", SocketOption.class, Object.class);
                setOptionMethod.invoke((Object)socket, ExtendedSocketOptions.class.getDeclaredField(TCP_KEEPCOUNT).get(null), 9);
                setOptionMethod.invoke((Object)socket, ExtendedSocketOptions.class.getDeclaredField(TCP_KEEPIDLE).get(null), 120);
                setOptionMethod.invoke((Object)socket, ExtendedSocketOptions.class.getDeclaredField(TCP_KEEPINTERVAL).get(null), 10);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private SocketStreamHelper() {
    }
}

