/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.reactivestreams.client.internal;

import com.mongodb.Block;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.Observables;
import com.mongodb.async.client.gridfs.GridFSBucket;
import com.mongodb.client.gridfs.model.GridFSDownloadOptions;
import com.mongodb.client.gridfs.model.GridFSUploadOptions;
import com.mongodb.reactivestreams.client.ClientSession;
import com.mongodb.reactivestreams.client.Success;
import com.mongodb.reactivestreams.client.gridfs.AsyncInputStream;
import com.mongodb.reactivestreams.client.gridfs.AsyncOutputStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSDownloadStream;
import com.mongodb.reactivestreams.client.gridfs.GridFSFindPublisher;
import com.mongodb.reactivestreams.client.gridfs.GridFSUploadStream;
import com.mongodb.reactivestreams.client.internal.GridFSAsyncStreamHelper;
import com.mongodb.reactivestreams.client.internal.GridFSDownloadStreamImpl;
import com.mongodb.reactivestreams.client.internal.GridFSFindPublisherImpl;
import com.mongodb.reactivestreams.client.internal.GridFSUploadStreamImpl;
import com.mongodb.reactivestreams.client.internal.ObservableToPublisher;
import com.mongodb.reactivestreams.client.internal.PublisherHelper;
import org.bson.BsonValue;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.reactivestreams.Publisher;

public final class GridFSBucketImpl
implements com.mongodb.reactivestreams.client.gridfs.GridFSBucket {
    private final GridFSBucket wrapped;

    public GridFSBucketImpl(GridFSBucket wrapped) {
        this.wrapped = (GridFSBucket)Assertions.notNull((String)"GridFSBucket", (Object)wrapped);
    }

    @Override
    public String getBucketName() {
        return this.wrapped.getBucketName();
    }

    @Override
    public int getChunkSizeBytes() {
        return this.wrapped.getChunkSizeBytes();
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.wrapped.getWriteConcern();
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.wrapped.getReadConcern();
    }

    @Override
    public boolean getDisableMD5() {
        return this.wrapped.getDisableMD5();
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withChunkSizeBytes(int chunkSizeBytes) {
        return new GridFSBucketImpl(this.wrapped.withChunkSizeBytes(chunkSizeBytes));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withReadPreference(ReadPreference readPreference) {
        return new GridFSBucketImpl(this.wrapped.withReadPreference(readPreference));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withWriteConcern(WriteConcern writeConcern) {
        return new GridFSBucketImpl(this.wrapped.withWriteConcern(writeConcern));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withReadConcern(ReadConcern readConcern) {
        return new GridFSBucketImpl(this.wrapped.withReadConcern(readConcern));
    }

    @Override
    public com.mongodb.reactivestreams.client.gridfs.GridFSBucket withDisableMD5(boolean disableMD5) {
        return new GridFSBucketImpl(this.wrapped.withDisableMD5(disableMD5));
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename) {
        return this.openUploadStream(filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(filename, options));
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename) {
        return this.openUploadStream(id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(BsonValue id, String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(id, filename, options));
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename) {
        return this.openUploadStream(clientSession, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(clientSession.getWrapped(), filename, options));
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename) {
        return this.openUploadStream(clientSession, id, filename, new GridFSUploadOptions());
    }

    @Override
    public GridFSUploadStream openUploadStream(ClientSession clientSession, BsonValue id, String filename, GridFSUploadOptions options) {
        return new GridFSUploadStreamImpl(this.wrapped.openUploadStream(clientSession.getWrapped(), id, filename, options));
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(String filename, AsyncInputStream source) {
        return this.uploadFromStream(filename, source, new GridFSUploadOptions());
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<ObjectId>(Observables.observe((Block)new Block<SingleResultCallback<ObjectId>>(){

            public void apply(SingleResultCallback<ObjectId> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> uploadFromStream(BsonValue id, String filename, AsyncInputStream source) {
        return this.uploadFromStream(id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public Publisher<Success> uploadFromStream(final BsonValue id, final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(id, filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(ClientSession clientSession, String filename, AsyncInputStream source) {
        return this.uploadFromStream(clientSession, filename, source, new GridFSUploadOptions());
    }

    @Override
    public Publisher<ObjectId> uploadFromStream(final ClientSession clientSession, final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<ObjectId>(Observables.observe((Block)new Block<SingleResultCallback<ObjectId>>(){

            public void apply(SingleResultCallback<ObjectId> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(clientSession.getWrapped(), filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, callback);
            }
        }));
    }

    @Override
    public Publisher<Success> uploadFromStream(ClientSession clientSession, BsonValue id, String filename, AsyncInputStream source) {
        return this.uploadFromStream(clientSession, id, filename, source, new GridFSUploadOptions());
    }

    @Override
    public Publisher<Success> uploadFromStream(final ClientSession clientSession, final BsonValue id, final String filename, final AsyncInputStream source, final GridFSUploadOptions options) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.uploadFromStream(clientSession.getWrapped(), id, filename, GridFSAsyncStreamHelper.toCallbackAsyncInputStream(source), options, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ObjectId id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(BsonValue id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename) {
        return this.openDownloadStream(filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(String filename, GridFSDownloadOptions options) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(filename, options));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, ObjectId id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(clientSession.getWrapped(), id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, BsonValue id) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(clientSession.getWrapped(), id));
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename) {
        return this.openDownloadStream(clientSession, filename, new GridFSDownloadOptions());
    }

    @Override
    public GridFSDownloadStream openDownloadStream(ClientSession clientSession, String filename, GridFSDownloadOptions options) {
        return new GridFSDownloadStreamImpl(this.wrapped.openDownloadStream(clientSession.getWrapped(), filename, options));
    }

    @Override
    public Publisher<Long> downloadToStream(final ObjectId id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(final BsonValue id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(String filename, AsyncOutputStream destination) {
        return this.downloadToStream(filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public Publisher<Long> downloadToStream(final String filename, final AsyncOutputStream destination, final GridFSDownloadOptions options) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(filename, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), options, callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(final ClientSession clientSession, final ObjectId id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(clientSession.getWrapped(), id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(final ClientSession clientSession, final BsonValue id, final AsyncOutputStream destination) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(clientSession.getWrapped(), id, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), callback);
            }
        }));
    }

    @Override
    public Publisher<Long> downloadToStream(ClientSession clientSession, String filename, AsyncOutputStream destination) {
        return this.downloadToStream(clientSession, filename, destination, new GridFSDownloadOptions());
    }

    @Override
    public Publisher<Long> downloadToStream(final ClientSession clientSession, final String filename, final AsyncOutputStream destination, final GridFSDownloadOptions options) {
        return new ObservableToPublisher<Long>(Observables.observe((Block)new Block<SingleResultCallback<Long>>(){

            public void apply(SingleResultCallback<Long> callback) {
                GridFSBucketImpl.this.wrapped.downloadToStream(clientSession.getWrapped(), filename, GridFSAsyncStreamHelper.toCallbackAsyncOutputStream(destination), options, callback);
            }
        }));
    }

    @Override
    public GridFSFindPublisher find() {
        return new GridFSFindPublisherImpl(this.wrapped.find());
    }

    @Override
    public GridFSFindPublisher find(Bson filter) {
        return new GridFSFindPublisherImpl(this.wrapped.find(filter));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession) {
        return new GridFSFindPublisherImpl(this.wrapped.find(clientSession.getWrapped()));
    }

    @Override
    public GridFSFindPublisher find(ClientSession clientSession, Bson filter) {
        return new GridFSFindPublisherImpl(this.wrapped.find(clientSession.getWrapped(), filter));
    }

    @Override
    public Publisher<Success> delete(final ObjectId id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> delete(final BsonValue id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> delete(final ClientSession clientSession, final ObjectId id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(clientSession.getWrapped(), id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> delete(final ClientSession clientSession, final BsonValue id) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.delete(clientSession.getWrapped(), id, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final ObjectId id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final BsonValue id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final ClientSession clientSession, final ObjectId id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(clientSession.getWrapped(), id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> rename(final ClientSession clientSession, final BsonValue id, final String newFilename) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.rename(clientSession.getWrapped(), id, newFilename, PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> drop() {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.drop(PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }

    @Override
    public Publisher<Success> drop(final ClientSession clientSession) {
        return new ObservableToPublisher<Success>(Observables.observe((Block)new Block<SingleResultCallback<Success>>(){

            public void apply(SingleResultCallback<Success> callback) {
                GridFSBucketImpl.this.wrapped.drop(clientSession.getWrapped(), PublisherHelper.voidToSuccessCallback(callback));
            }
        }));
    }
}

