/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.descriptor.tld;

import java.io.IOException;
import java.io.InputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.descriptor.DigesterFactory;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.descriptor.tld.TaglibXml;
import org.apache.tomcat.util.descriptor.tld.TldResourcePath;
import org.apache.tomcat.util.descriptor.tld.TldRuleSet;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.RuleSet;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TldParser {
    private static final Log log = LogFactory.getLog(TldParser.class);
    private final Digester digester;

    public TldParser(boolean namespaceAware, boolean validation, boolean blockExternal) {
        this(namespaceAware, validation, new TldRuleSet(), blockExternal);
    }

    public TldParser(boolean namespaceAware, boolean validation, RuleSet ruleSet, boolean blockExternal) {
        this.digester = DigesterFactory.newDigester(validation, namespaceAware, ruleSet, blockExternal);
    }

    /*
     * Loose catch block
     */
    public TaglibXml parse(TldResourcePath path) throws IOException, SAXException {
        try {
            try (InputStream is = path.openStream();){
                XmlErrorHandler handler = new XmlErrorHandler();
                this.digester.setErrorHandler(handler);
                TaglibXml taglibXml = new TaglibXml();
                this.digester.push(taglibXml);
                InputSource source = new InputSource(path.toExternalForm());
                source.setByteStream(is);
                this.digester.parse(source);
                if (!handler.getWarnings().isEmpty() || !handler.getErrors().isEmpty()) {
                    handler.logFindings(log, source.getSystemId());
                    if (!handler.getErrors().isEmpty()) {
                        throw handler.getErrors().iterator().next();
                    }
                }
                TaglibXml taglibXml2 = taglibXml;
                return taglibXml2;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.digester.reset();
        }
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.digester.setClassLoader(classLoader);
    }
}

