/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.scan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.tomcat.Jar;

public class JarFileUrlJar
implements Jar {
    private final JarFile jarFile;
    private final URL jarFileURL;
    private Enumeration<JarEntry> entries;
    private JarEntry entry = null;

    public JarFileUrlJar(URL url, boolean startsWithJar) throws IOException {
        if (startsWithJar) {
            JarURLConnection jarConn = (JarURLConnection)url.openConnection();
            jarConn.setUseCaches(false);
            this.jarFile = jarConn.getJarFile();
            this.jarFileURL = jarConn.getJarFileURL();
        } else {
            File f;
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
            this.jarFile = new JarFile(f);
            this.jarFileURL = url;
        }
    }

    @Override
    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    @Override
    public boolean entryExists(String name) {
        ZipEntry entry = this.jarFile.getEntry(name);
        return entry != null;
    }

    @Override
    public InputStream getInputStream(String name) throws IOException {
        ZipEntry entry = this.jarFile.getEntry(name);
        if (entry == null) {
            return null;
        }
        return this.jarFile.getInputStream(entry);
    }

    @Override
    public long getLastModified(String name) throws IOException {
        ZipEntry entry = this.jarFile.getEntry(name);
        if (entry == null) {
            return -1L;
        }
        return entry.getTime();
    }

    @Override
    public String getURL(String entry) {
        StringBuilder result = new StringBuilder("jar:");
        result.append(this.getJarFileURL().toExternalForm());
        result.append("!/");
        result.append(entry);
        return result.toString();
    }

    @Override
    public void close() {
        if (this.jarFile != null) {
            try {
                this.jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void nextEntry() {
        if (this.entries == null) {
            this.entries = this.jarFile.entries();
        }
        this.entry = this.entries.hasMoreElements() ? this.entries.nextElement() : null;
    }

    @Override
    public String getEntryName() {
        if (this.entry == null) {
            return null;
        }
        return this.entry.getName();
    }

    @Override
    public InputStream getEntryInputStream() throws IOException {
        if (this.entry == null) {
            return null;
        }
        return this.jarFile.getInputStream(this.entry);
    }

    @Override
    public Manifest getManifest() throws IOException {
        return this.jarFile.getManifest();
    }

    @Override
    public void reset() throws IOException {
        this.entries = null;
        this.entry = null;
    }
}

