/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mortbay.log.Log;
import org.mortbay.thread.BoundedThreadPool;

public class IO
extends BoundedThreadPool {
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = 16384;
    private static NullOS __nullStream = new NullOS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream in, OutputStream out) {
        try {
            Job job = new Job(in, out);
            if (!IO.instance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copyThread(Reader in, Writer out) {
        try {
            Job job = new Job(in, out);
            if (!IO.instance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception e) {
            Log.warn(e);
        }
    }

    public static void copy(Reader in, Writer out) throws IOException {
        IO.copy(in, out, -1L);
    }

    public static void copy(InputStream in, OutputStream out, long byteCount) throws IOException {
        byte[] buffer = new byte[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(Reader in, Writer out, long byteCount) throws IOException {
        char[] buffer = new char[bufferSize];
        int len = bufferSize;
        if (byteCount >= 0L) {
            while (byteCount > 0L && (len = byteCount < (long)bufferSize ? in.read(buffer, 0, (int)byteCount) : in.read(buffer, 0, bufferSize)) != -1) {
                byteCount -= (long)len;
                out.write(buffer, 0, len);
            }
        } else {
            while ((len = in.read(buffer, 0, bufferSize)) != -1) {
                out.write(buffer, 0, len);
            }
        }
    }

    public static void copy(File from, File to) throws IOException {
        if (from.isDirectory()) {
            IO.copyDir(from, to);
        } else {
            IO.copyFile(from, to);
        }
    }

    public static void copyDir(File from, File to) throws IOException {
        File[] files;
        if (to.exists()) {
            if (!to.isDirectory()) {
                throw new IllegalArgumentException(to.toString());
            }
        } else {
            to.mkdirs();
        }
        if ((files = from.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (".".equals(name) || "..".equals(name)) continue;
                IO.copy(files[i], new File(to, name));
            }
        }
    }

    public static void copyFile(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        IO.copy(in, out);
        in.close();
        out.close();
    }

    public static String toString(InputStream in) throws IOException {
        return IO.toString(in, null);
    }

    public static String toString(InputStream in, String encoding) throws IOException {
        StringWriter writer = new StringWriter();
        InputStreamReader reader = encoding == null ? new InputStreamReader(in) : new InputStreamReader(in, encoding);
        IO.copy(reader, writer);
        return writer.toString();
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; files != null && i < files.length; ++i) {
                IO.delete(files[i]);
            }
        }
        return file.delete();
    }

    public static void close(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
    }

    public static byte[] readBytes(InputStream in) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        IO.copy(in, bout);
        return bout.toByteArray();
    }

    public static void close(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException e) {
            Log.ignore(e);
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(char[] b) {
        }

        public void write(char[] b, int o, int l) {
        }

        public void write(int b) {
        }

        public void write(String s) {
        }

        public void write(String s, int o, int l) {
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        public void close() {
        }

        public void flush() {
        }

        public void write(byte[] b) {
        }

        public void write(byte[] b, int i, int l) {
        }

        public void write(int b) {
        }
    }

    static class Job
    implements Runnable {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
            this.read = null;
            this.write = null;
        }

        Job(Reader read, Writer write) {
            this.in = null;
            this.out = null;
            this.read = read;
            this.write = write;
        }

        public void run() {
            try {
                if (this.in != null) {
                    IO.copy(this.in, this.out, -1L);
                } else {
                    IO.copy(this.read, this.write, -1L);
                }
            }
            catch (IOException e) {
                Log.ignore(e);
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.write != null) {
                        this.write.close();
                    }
                }
                catch (IOException e2) {
                    Log.ignore(e2);
                }
            }
        }
    }

    private static class Singleton {
        static final IO __instance = new IO();

        private Singleton() {
        }

        static {
            try {
                __instance.start();
            }
            catch (Exception e) {
                Log.warn(e);
                System.exit(1);
            }
        }
    }
}

