/*
 * Decompiled with CFR 0.152.
 */
package org.mvel2.ast;

import java.io.Serializable;
import java.util.ArrayList;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;
import org.mvel2.ast.BlockNode;
import org.mvel2.ast.NestedStatement;
import org.mvel2.compiler.ExecutableStatement;
import org.mvel2.integration.VariableResolverFactory;
import org.mvel2.util.ParseTools;
import org.mvel2.util.PropertyTools;

public class WithNode
extends BlockNode
implements NestedStatement {
    protected String nestParm;
    protected ParmValuePair[] withExpressions;

    public WithNode(char[] expr, int start, int offset, int blockStart, int blockOffset, int fields, ParserContext pCtx) {
        this.expr = expr;
        this.start = start;
        this.offset = offset;
        this.nestParm = ParseTools.createStringTrimmed(expr, this.start, this.offset);
        this.blockStart = blockStart;
        this.blockOffset = blockOffset;
        if ((fields & 0x10) != 0) {
            pCtx.setBlockSymbols(true);
            this.compiledBlock = (ExecutableStatement)ParseTools.subCompileExpression(expr, start, offset, pCtx);
            this.egressType = this.compiledBlock.getKnownEgressType();
            this.withExpressions = WithNode.compileWithExpressions(expr, blockStart, blockOffset, this.nestParm, this.egressType, pCtx);
            pCtx.setBlockSymbols(false);
        }
    }

    public Object getReducedValueAccelerated(Object ctx, Object thisValue, VariableResolverFactory factory) {
        Object ctxObject = this.compiledBlock.getValue(ctx, thisValue, factory);
        if (ctxObject == null) {
            throw new CompileException("with-block against null pointer", this.expr, this.start);
        }
        for (ParmValuePair pvp : this.withExpressions) {
            pvp.eval(ctxObject, factory);
        }
        return ctxObject;
    }

    public Object getReducedValue(Object ctx, Object thisValue, VariableResolverFactory factory) {
        ctx = MVEL.eval(this.expr, this.start, this.offset, ctx, factory);
        ParseTools.parseWithExpressions(this.nestParm, this.expr, this.blockStart, this.blockOffset, ctx, factory);
        return ctx;
    }

    public static ParmValuePair[] compileWithExpressions(char[] block, int start, int offset, String nestParm, Class egressType, ParserContext pCtx) {
        ArrayList<ParmValuePair> parms = new ArrayList<ParmValuePair>();
        String parm = "";
        int end = start + offset;
        int _st = start;
        int _end = -1;
        int oper = -1;
        block13: for (int i = start; i < end; ++i) {
            switch (block[i]) {
                case '(': 
                case '[': 
                case '{': {
                    i = ParseTools.balancedCapture(block, i, end, block[i]);
                    continue block13;
                }
                case '/': {
                    if (i < end && block[i + 1] == '/') {
                        while (i < end && block[i] != '\n') {
                            block[i++] = 32;
                        }
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i < end && block[i + 1] == '*') {
                        int len = end - 1;
                        while (i < len && (block[i] != '*' || block[i + 1] != '/')) {
                            block[i++] = 32;
                        }
                        block[i++] = 32;
                        block[i++] = 32;
                        if (parm != null) continue block13;
                        _st = i;
                        continue block13;
                    }
                    if (i >= end || block[i + 1] != '=') continue block13;
                    oper = 3;
                    continue block13;
                }
                case '%': 
                case '*': 
                case '+': 
                case '-': {
                    if (i + 1 >= end || block[i + 1] != '=') continue block13;
                    oper = ParseTools.opLookup(block[i]);
                    continue block13;
                }
                case '=': {
                    parm = ParseTools.createStringTrimmed(block, _st, i - _st - (oper != -1 ? 1 : 0));
                    _st = i + 1;
                    continue block13;
                }
                case ',': {
                    if (_end == -1) {
                        _end = i;
                    }
                    if (parm == null || parm.length() == 0) {
                        try {
                            parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(nestParm + '.' + new String(block, _st, _end - _st), pCtx), block, _st, egressType, pCtx));
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        oper = -1;
                        _st = ++i;
                    } else {
                        try {
                            parms.add(new ParmValuePair(parm, oper != -1 ? (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper), pCtx) : (ExecutableStatement)ParseTools.subCompileExpression(block, _st, _end - _st, pCtx), block, _st, Object.class, pCtx));
                        }
                        catch (CompileException e) {
                            e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                            e.setExpr(block);
                            throw e;
                        }
                        parm = null;
                        oper = -1;
                        _st = ++i;
                    }
                    _end = -1;
                }
            }
        }
        _end = end;
        if (_st != _end) {
            try {
                if (parm == null || "".equals(parm)) {
                    parms.add(new ParmValuePair(null, (ExecutableStatement)ParseTools.subCompileExpression(nestParm + '.' + new String(block, _st, _end - _st), pCtx), block, _st, egressType, pCtx));
                } else {
                    parms.add(new ParmValuePair(parm, oper != -1 ? (ExecutableStatement)ParseTools.subCompileExpression(ParseTools.createShortFormOperativeAssignment(nestParm + "." + parm, block, _st, _end - _st, oper), pCtx) : (ExecutableStatement)ParseTools.subCompileExpression(block, _st, _end - _st, pCtx), block, _st, Object.class, pCtx));
                }
            }
            catch (CompileException e) {
                e.setCursor(_st + (e.getCursor() - (e.getExpr().length - offset)));
                e.setExpr(block);
                throw e;
            }
        }
        ParmValuePair[] withExpressions = new ParmValuePair[parms.size()];
        parms.toArray(withExpressions);
        return withExpressions;
    }

    public ExecutableStatement getNestedStatement() {
        return this.compiledBlock;
    }

    public ParmValuePair[] getWithExpressions() {
        return this.withExpressions;
    }

    public static final class ParmValuePair
    implements Serializable {
        private char[] expr;
        private int cursor;
        private Serializable setExpression;
        private ExecutableStatement statement;

        public ParmValuePair() {
        }

        public ParmValuePair(String parameter, ExecutableStatement statement, char[] expr, int cursor, Class ingressType, ParserContext pCtx) {
            this.expr = expr;
            this.cursor = cursor;
            if (parameter != null && parameter.length() != 0) {
                this.setExpression = MVEL.compileSetExpression(parameter, ingressType != null ? PropertyTools.getReturnType(ingressType, parameter, pCtx) : Object.class, pCtx);
            }
            this.statement = statement;
        }

        public Serializable getSetExpression() {
            return this.setExpression;
        }

        public void setSetExpression(Serializable setExpression) {
            this.setExpression = setExpression;
        }

        public ExecutableStatement getStatement() {
            return this.statement;
        }

        public void setStatement(ExecutableStatement statement) {
            this.statement = statement;
        }

        public void eval(Object ctx, VariableResolverFactory factory) {
            if (this.setExpression == null) {
                this.statement.getValue(ctx, factory);
            } else {
                MVEL.executeSetExpression(this.setExpression, ctx, factory, this.statement.getValue(ctx, factory));
            }
        }
    }
}

