/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.SqlCriterionVisitor;

public abstract class SqlCriterion {
    private final String connector;
    private final List<SqlCriterion> subCriteria;

    protected SqlCriterion(AbstractBuilder<?> builder) {
        this.connector = ((AbstractBuilder)builder).connector;
        this.subCriteria = Objects.requireNonNull(((AbstractBuilder)builder).subCriteria);
    }

    public Optional<String> connector() {
        return Optional.ofNullable(this.connector);
    }

    public <R> Stream<R> mapSubCriteria(Function<SqlCriterion, R> mapper) {
        return this.subCriteria.stream().map(mapper);
    }

    public abstract <R> R accept(SqlCriterionVisitor<R> var1);

    protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>> {
        private String connector;
        private final List<SqlCriterion> subCriteria = new ArrayList<SqlCriterion>();

        protected AbstractBuilder() {
        }

        public T withConnector(String connector) {
            this.connector = connector;
            return this.getThis();
        }

        public T withSubCriteria(List<SqlCriterion> subCriteria) {
            this.subCriteria.addAll(subCriteria);
            return this.getThis();
        }

        protected abstract T getThis();
    }
}

