/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.mybatis.dynamic.sql.insert.MultiRowInsertModel;
import org.mybatis.dynamic.sql.insert.render.DefaultMultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.insert.render.MultiRowInsertStatementProvider;
import org.mybatis.dynamic.sql.insert.render.MultiRowValuePhraseVisitor;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class MultiRowInsertRenderer<T> {
    private final MultiRowInsertModel<T> model;
    private final RenderingStrategy renderingStrategy;

    private MultiRowInsertRenderer(Builder<T> builder) {
        this.model = Objects.requireNonNull(((Builder)builder).model);
        this.renderingStrategy = Objects.requireNonNull(((Builder)builder).renderingStrategy);
    }

    public MultiRowInsertStatementProvider<T> render() {
        MultiRowValuePhraseVisitor visitor = new MultiRowValuePhraseVisitor(this.renderingStrategy, "records[%s]");
        List<FieldAndValue> fieldsAndValues = this.model.mapColumnMappings(m -> m.accept(visitor)).collect(Collectors.toList());
        return new DefaultMultiRowInsertStatementProvider.Builder().withRecords(this.model.records()).withInsertStatement(this.calculateInsertStatement(fieldsAndValues)).build();
    }

    private String calculateInsertStatement(List<FieldAndValue> fieldsAndValues) {
        return "insert into" + StringUtilities.spaceBefore(this.model.table().tableNameAtRuntime()) + StringUtilities.spaceBefore(this.calculateColumnsPhrase(fieldsAndValues)) + StringUtilities.spaceBefore(this.calculateMultiRowInsertValuesPhrase(fieldsAndValues, this.model.recordCount()));
    }

    private String calculateColumnsPhrase(List<FieldAndValue> fieldsAndValues) {
        return fieldsAndValues.stream().map(FieldAndValue::fieldName).collect(Collectors.joining(", ", "(", ")"));
    }

    private String calculateMultiRowInsertValuesPhrase(List<FieldAndValue> fieldsAndValues, int rowCount) {
        return IntStream.range(0, rowCount).mapToObj(i -> this.toSingleRowOfValues(fieldsAndValues, i)).collect(Collectors.joining(", ", "values ", ""));
    }

    private String toSingleRowOfValues(List<FieldAndValue> fieldsAndValues, int row) {
        return fieldsAndValues.stream().map(FieldAndValue::valuePhrase).map(s -> String.format(s, row)).collect(Collectors.joining(", ", "(", ")"));
    }

    public static <T> Builder<T> withMultiRowInsertModel(MultiRowInsertModel<T> model) {
        return new Builder<T>().withMultiRowInsertModel(model);
    }

    public static class Builder<T> {
        private MultiRowInsertModel<T> model;
        private RenderingStrategy renderingStrategy;

        public Builder<T> withMultiRowInsertModel(MultiRowInsertModel<T> model) {
            this.model = model;
            return this;
        }

        public Builder<T> withRenderingStrategy(RenderingStrategy renderingStrategy) {
            this.renderingStrategy = renderingStrategy;
            return this;
        }

        public MultiRowInsertRenderer<T> build() {
            return new MultiRowInsertRenderer(this);
        }
    }
}

