/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.select.render;

import java.util.Objects;
import java.util.stream.Collectors;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.select.QueryExpressionModel;
import org.mybatis.dynamic.sql.select.join.JoinCriterion;
import org.mybatis.dynamic.sql.select.join.JoinModel;
import org.mybatis.dynamic.sql.select.join.JoinSpecification;
import org.mybatis.dynamic.sql.select.render.TableExpressionRenderer;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.FragmentCollector;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class JoinRenderer {
    private final JoinModel joinModel;
    private final QueryExpressionModel queryExpression;
    private final TableExpressionRenderer tableExpressionRenderer;

    private JoinRenderer(Builder builder) {
        this.joinModel = Objects.requireNonNull(builder.joinModel);
        this.queryExpression = Objects.requireNonNull(builder.queryExpression);
        this.tableExpressionRenderer = Objects.requireNonNull(builder.tableExpressionRenderer);
    }

    public FragmentAndParameters render() {
        FragmentCollector fc = this.joinModel.mapJoinSpecifications(this::renderJoinSpecification).collect(FragmentCollector.collect());
        return FragmentAndParameters.withFragment(fc.fragments().collect(Collectors.joining(" "))).withParameters(fc.parameters()).build();
    }

    private FragmentAndParameters renderJoinSpecification(JoinSpecification joinSpecification) {
        FragmentAndParameters renderedTable = joinSpecification.table().accept(this.tableExpressionRenderer);
        String fragment = StringUtilities.spaceAfter(joinSpecification.joinType().shortType()) + "join" + StringUtilities.spaceBefore(renderedTable.fragment()) + StringUtilities.spaceBefore(this.renderConditions(joinSpecification));
        return FragmentAndParameters.withFragment(fragment).withParameters(renderedTable.parameters()).build();
    }

    private String renderConditions(JoinSpecification joinSpecification) {
        return joinSpecification.mapJoinCriteria(this::renderCriterion).collect(Collectors.joining(" "));
    }

    private String renderCriterion(JoinCriterion joinCriterion) {
        return joinCriterion.connector() + StringUtilities.spaceBefore(this.applyTableAlias(joinCriterion.leftColumn())) + StringUtilities.spaceBefore(joinCriterion.operator()) + StringUtilities.spaceBefore(this.applyTableAlias(joinCriterion.rightColumn()));
    }

    private String applyTableAlias(BasicColumn column) {
        return column.renderWithTableAlias(this.queryExpression.tableAliasCalculator());
    }

    public static Builder withJoinModel(JoinModel joinModel) {
        return new Builder().withJoinModel(joinModel);
    }

    public static class Builder {
        private JoinModel joinModel;
        private QueryExpressionModel queryExpression;
        private TableExpressionRenderer tableExpressionRenderer;

        public Builder withJoinModel(JoinModel joinModel) {
            this.joinModel = joinModel;
            return this;
        }

        public Builder withQueryExpression(QueryExpressionModel queryExpression) {
            this.queryExpression = queryExpression;
            return this;
        }

        public Builder withTableExpressionRenderer(TableExpressionRenderer tableExpressionRenderer) {
            this.tableExpressionRenderer = tableExpressionRenderer;
            return this;
        }

        public JoinRenderer build() {
            return new JoinRenderer(this);
        }
    }
}

