/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.Buildable;
import org.mybatis.dynamic.sql.util.ColumnToColumnMapping;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.SelectMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;
import org.mybatis.dynamic.sql.where.AbstractWhereDSL;
import org.mybatis.dynamic.sql.where.AbstractWhereSupport;
import org.mybatis.dynamic.sql.where.WhereModel;

public class UpdateDSL<R>
extends AbstractWhereSupport<UpdateWhereBuilder>
implements Buildable<R> {
    private final Function<UpdateModel, R> adapterFunction;
    private final List<AbstractColumnMapping> columnMappings = new ArrayList<AbstractColumnMapping>();
    private final SqlTable table;
    private final UpdateWhereBuilder whereBuilder = new UpdateWhereBuilder();

    private UpdateDSL(SqlTable table, Function<UpdateModel, R> adapterFunction) {
        this.table = Objects.requireNonNull(table);
        this.adapterFunction = Objects.requireNonNull(adapterFunction);
    }

    public <T> SetClauseFinisher<T> set(SqlColumn<T> column) {
        return new SetClauseFinisher<T>(column);
    }

    @Override
    public UpdateWhereBuilder where() {
        return this.whereBuilder;
    }

    @Override
    @NotNull
    public R build() {
        UpdateModel updateModel = UpdateModel.withTable(this.table).withColumnMappings(this.columnMappings).withWhereModel(this.whereBuilder.buildWhereModel()).build();
        return this.adapterFunction.apply(updateModel);
    }

    public static <R> UpdateDSL<R> update(Function<UpdateModel, R> adapterFunction, SqlTable table) {
        return new UpdateDSL<R>(table, adapterFunction);
    }

    public static UpdateDSL<UpdateModel> update(SqlTable table) {
        return UpdateDSL.update(Function.identity(), table);
    }

    public class UpdateWhereBuilder
    extends AbstractWhereDSL<UpdateWhereBuilder>
    implements Buildable<R> {
        private UpdateWhereBuilder() {
        }

        @Override
        @NotNull
        public R build() {
            return UpdateDSL.this.build();
        }

        @Override
        protected UpdateWhereBuilder getThis() {
            return this;
        }

        protected WhereModel buildWhereModel() {
            return this.internalBuild();
        }
    }

    public class SetClauseFinisher<T> {
        private final SqlColumn<T> column;

        public SetClauseFinisher(SqlColumn<T> column) {
            this.column = column;
        }

        public UpdateDSL<R> equalToNull() {
            UpdateDSL.this.columnMappings.add(NullMapping.of(this.column));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalToConstant(String constant) {
            UpdateDSL.this.columnMappings.add(ConstantMapping.of(this.column, constant));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalToStringConstant(String constant) {
            UpdateDSL.this.columnMappings.add(StringConstantMapping.of(this.column, constant));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalTo(T value) {
            return this.equalTo(() -> value);
        }

        public UpdateDSL<R> equalTo(Supplier<T> valueSupplier) {
            UpdateDSL.this.columnMappings.add(ValueMapping.of(this.column, valueSupplier));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalTo(Buildable<SelectModel> buildable) {
            UpdateDSL.this.columnMappings.add(SelectMapping.of(this.column, buildable));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalTo(BasicColumn rightColumn) {
            UpdateDSL.this.columnMappings.add(ColumnToColumnMapping.of(this.column, rightColumn));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalToOrNull(T value) {
            return this.equalToOrNull(() -> value);
        }

        public UpdateDSL<R> equalToOrNull(Supplier<T> valueSupplier) {
            UpdateDSL.this.columnMappings.add(ValueOrNullMapping.of(this.column, valueSupplier));
            return UpdateDSL.this;
        }

        public UpdateDSL<R> equalToWhenPresent(T value) {
            return this.equalToWhenPresent(() -> value);
        }

        public UpdateDSL<R> equalToWhenPresent(Supplier<T> valueSupplier) {
            UpdateDSL.this.columnMappings.add(ValueWhenPresentMapping.of(this.column, valueSupplier));
            return UpdateDSL.this;
        }
    }
}

