/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsIn<T>
extends AbstractListValueCondition<T> {
    private static final IsIn<?> EMPTY = new IsIn(Collections.emptyList());

    public static <T> IsIn<T> empty() {
        IsIn<?> t = EMPTY;
        return t;
    }

    protected IsIn(Collection<T> values) {
        super(values);
    }

    protected IsIn(Collection<T> values, Callback emptyCallback) {
        super(values, emptyCallback);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "in (", ")"));
    }

    @Override
    public IsIn<T> withListEmptyCallback(Callback callback) {
        return new IsIn<T>(this.values, callback);
    }

    @Deprecated
    public IsIn<T> then(UnaryOperator<Stream<T>> valueStreamTransformer) {
        List mapped = ((Stream)valueStreamTransformer.apply(this.values.stream())).collect(Collectors.toList());
        return new IsIn(mapped, this.emptyCallback);
    }

    @Override
    public IsIn<T> filter(Predicate<? super T> predicate) {
        return this.filterSupport(predicate, IsIn::new, this, IsIn::empty);
    }

    public <R> IsIn<R> map(Function<? super T, ? extends R> mapper) {
        BiFunction<Collection, Callback, IsIn> constructor = IsIn::new;
        return this.mapSupport(mapper, constructor, IsIn::empty);
    }

    @SafeVarargs
    public static <T> IsIn<T> of(T ... values) {
        return IsIn.of(Arrays.asList(values));
    }

    public static <T> IsIn<T> of(Collection<T> values) {
        return new IsIn<T>(values);
    }
}

