/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.mybatis.dynamic.sql.AbstractSingleValueCondition;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsLikeCaseInsensitive
extends AbstractSingleValueCondition<String> {
    private static final IsLikeCaseInsensitive EMPTY = new IsLikeCaseInsensitive(null){

        @Override
        public boolean shouldRender() {
            return false;
        }
    };

    public static IsLikeCaseInsensitive empty() {
        return EMPTY;
    }

    protected IsLikeCaseInsensitive(String value) {
        super(value);
    }

    @Override
    public String renderCondition(String columnName, String placeholder) {
        return "upper(" + columnName + ") like " + placeholder;
    }

    @Override
    public String value() {
        return StringUtilities.safelyUpperCase((String)super.value());
    }

    public static IsLikeCaseInsensitive of(String value) {
        return new IsLikeCaseInsensitive(value);
    }

    @Deprecated
    public IsLikeCaseInsensitive when(Predicate<String> predicate) {
        return this.filter(predicate);
    }

    @Deprecated
    public IsLikeCaseInsensitive then(UnaryOperator<String> mapper) {
        return this.map(mapper);
    }

    public IsLikeCaseInsensitive filter(Predicate<? super String> predicate) {
        return this.filterSupport(predicate, IsLikeCaseInsensitive::empty, this);
    }

    public IsLikeCaseInsensitive map(UnaryOperator<String> mapper) {
        return this.mapSupport(mapper, IsLikeCaseInsensitive::new, IsLikeCaseInsensitive::empty);
    }
}

