/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotIn<T>
extends AbstractListValueCondition<T> {
    private static final IsNotIn<?> EMPTY = new IsNotIn(Collections.emptyList());

    public static <T> IsNotIn<T> empty() {
        IsNotIn<?> t = EMPTY;
        return t;
    }

    protected IsNotIn(Collection<T> values) {
        super(values);
    }

    protected IsNotIn(Collection<T> values, Callback emptyCallback) {
        super(values, emptyCallback);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return StringUtilities.spaceAfter(columnName) + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    @Override
    public IsNotIn<T> withListEmptyCallback(Callback callback) {
        return new IsNotIn<T>(this.values, callback);
    }

    @Deprecated
    public IsNotIn<T> then(UnaryOperator<Stream<T>> valueStreamTransformer) {
        List mapped = ((Stream)valueStreamTransformer.apply(this.values.stream())).collect(Collectors.toList());
        return new IsNotIn(mapped, this.emptyCallback);
    }

    @Override
    public IsNotIn<T> filter(Predicate<? super T> predicate) {
        return this.filterSupport(predicate, IsNotIn::new, this, IsNotIn::empty);
    }

    public <R> IsNotIn<R> map(Function<? super T, ? extends R> mapper) {
        BiFunction<Collection, Callback, IsNotIn> constructor = IsNotIn::new;
        return this.mapSupport(mapper, constructor, IsNotIn::empty);
    }

    @SafeVarargs
    public static <T> IsNotIn<T> of(T ... values) {
        return IsNotIn.of(Arrays.asList(values));
    }

    public static <T> IsNotIn<T> of(Collection<T> values) {
        return new IsNotIn<T>(values);
    }
}

