/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.generator.maven;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mybatis.generator.api.MyBatisGenerator;
import org.mybatis.generator.api.ProgressCallback;
import org.mybatis.generator.api.ShellCallback;
import org.mybatis.generator.config.Configuration;
import org.mybatis.generator.config.xml.ConfigurationParser;
import org.mybatis.generator.exception.InvalidConfigurationException;
import org.mybatis.generator.exception.XMLParserException;
import org.mybatis.generator.internal.ObjectFactory;
import org.mybatis.generator.internal.util.ClassloaderUtility;
import org.mybatis.generator.internal.util.StringUtility;
import org.mybatis.generator.internal.util.messages.Messages;
import org.mybatis.generator.maven.MavenProgressCallback;
import org.mybatis.generator.maven.MavenShellCallback;
import org.mybatis.generator.maven.SqlScriptRunner;

public class MyBatisGeneratorMojo
extends AbstractMojo {
    private MavenProject project;
    private File outputDirectory;
    private File configurationFile;
    private boolean verbose;
    private boolean overwrite;
    private String sqlScript;
    private String jdbcDriver;
    private String jdbcURL;
    private String jdbcUserId;
    private String jdbcPassword;
    private String tableNames;
    private String contexts;

    public void execute() throws MojoExecutionException {
        List resources = this.project.getResources();
        ArrayList<String> resourceDirectories = new ArrayList<String>();
        for (Resource resource : resources) {
            resourceDirectories.add(resource.getDirectory());
        }
        ClassLoader cl = ClassloaderUtility.getCustomClassloader(resourceDirectories);
        ObjectFactory.addResourceClassLoader((ClassLoader)cl);
        if (this.configurationFile == null) {
            throw new MojoExecutionException(Messages.getString((String)"RuntimeError.0"));
        }
        ArrayList warnings = new ArrayList();
        if (!this.configurationFile.exists()) {
            throw new MojoExecutionException(Messages.getString((String)"RuntimeError.1", (String)this.configurationFile.toString()));
        }
        this.runScriptIfNecessary();
        HashSet<String> fullyqualifiedTables = new HashSet<String>();
        if (StringUtility.stringHasValue((String)this.tableNames)) {
            StringTokenizer st = new StringTokenizer(this.tableNames, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                fullyqualifiedTables.add(s);
            }
        }
        HashSet<String> contextsToRun = new HashSet<String>();
        if (StringUtility.stringHasValue((String)this.contexts)) {
            StringTokenizer st = new StringTokenizer(this.contexts, ",");
            while (st.hasMoreTokens()) {
                String s = st.nextToken().trim();
                if (s.length() <= 0) continue;
                contextsToRun.add(s);
            }
        }
        try {
            ConfigurationParser cp = new ConfigurationParser(this.project.getProperties(), warnings);
            Configuration config = cp.parseConfiguration(this.configurationFile);
            MavenShellCallback callback = new MavenShellCallback(this, this.overwrite);
            MyBatisGenerator myBatisGenerator = new MyBatisGenerator(config, (ShellCallback)callback, warnings);
            myBatisGenerator.generate((ProgressCallback)new MavenProgressCallback(this.getLog(), this.verbose), contextsToRun, fullyqualifiedTables);
        }
        catch (XMLParserException e) {
            for (String error : e.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (SQLException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InvalidConfigurationException e) {
            for (String error : e.getErrors()) {
                this.getLog().error((CharSequence)error);
            }
            throw new MojoExecutionException(e.getMessage());
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        for (String error : warnings) {
            this.getLog().warn((CharSequence)error);
        }
        if (this.project != null && this.outputDirectory != null && this.outputDirectory.exists()) {
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
            Resource resource = new Resource();
            resource.setDirectory(this.outputDirectory.getAbsolutePath());
            resource.addInclude("**/*.xml");
            this.project.addResource(resource);
        }
    }

    private void runScriptIfNecessary() throws MojoExecutionException {
        if (this.sqlScript == null) {
            return;
        }
        SqlScriptRunner scriptRunner = new SqlScriptRunner(this.sqlScript, this.jdbcDriver, this.jdbcURL, this.jdbcUserId, this.jdbcPassword);
        scriptRunner.setLog(this.getLog());
        scriptRunner.executeScript();
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }
}

