/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.cluster;

import java.util.concurrent.TimeUnit;
import org.neo4j.driver.internal.cluster.RoutingContext;

public class RoutingSettings {
    public static final RoutingSettings DEFAULT = new RoutingSettings(1, TimeUnit.SECONDS.toMillis(5L));
    private final int maxRoutingFailures;
    private final long retryTimeoutDelay;
    private final RoutingContext routingContext;

    public RoutingSettings(int maxRoutingFailures, long retryTimeoutDelay) {
        this(maxRoutingFailures, retryTimeoutDelay, RoutingContext.EMPTY);
    }

    public RoutingSettings(int maxRoutingFailures, long retryTimeoutDelay, RoutingContext routingContext) {
        this.maxRoutingFailures = maxRoutingFailures;
        this.retryTimeoutDelay = retryTimeoutDelay;
        this.routingContext = routingContext;
    }

    public RoutingSettings withRoutingContext(RoutingContext newRoutingContext) {
        return new RoutingSettings(this.maxRoutingFailures, this.retryTimeoutDelay, newRoutingContext);
    }

    public int maxRoutingFailures() {
        return this.maxRoutingFailures;
    }

    public long retryTimeoutDelay() {
        return this.retryTimeoutDelay;
    }

    public RoutingContext routingContext() {
        return this.routingContext;
    }
}

