/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.handlers;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.InternalBookmark;
import org.neo4j.driver.internal.spi.ResponseHandler;

public class CommitTxResponseHandler
implements ResponseHandler {
    private final CompletableFuture<Bookmark> commitFuture;

    public CommitTxResponseHandler(CompletableFuture<Bookmark> commitFuture) {
        this.commitFuture = Objects.requireNonNull(commitFuture);
    }

    @Override
    public void onSuccess(Map<String, Value> metadata) {
        Value bookmarkValue = metadata.get("bookmark");
        if (bookmarkValue == null) {
            this.commitFuture.complete(null);
        } else {
            this.commitFuture.complete(InternalBookmark.parse(bookmarkValue.asString()));
        }
    }

    @Override
    public void onFailure(Throwable error) {
        this.commitFuture.completeExceptionally(error);
    }

    @Override
    public void onRecord(Value[] fields) {
        throw new UnsupportedOperationException("Transaction commit is not expected to receive records: " + Arrays.toString(fields));
    }
}

