/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.neo4j.driver.NotificationConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.BoltAgent;
import org.neo4j.driver.internal.messaging.request.MessageWithMetadata;

public class HelloMessage
extends MessageWithMetadata {
    public static final byte SIGNATURE = 1;
    private static final String USER_AGENT_METADATA_KEY = "user_agent";
    private static final String BOLT_AGENT_METADATA_KEY = "bolt_agent";
    private static final String BOLT_AGENT_PRODUCT_KEY = "product";
    private static final String BOLT_AGENT_PLATFORM_KEY = "platform";
    private static final String BOLT_AGENT_LANGUAGE_KEY = "language";
    private static final String BOLT_AGENT_LANGUAGE_DETAIL_KEY = "language_details";
    private static final String ROUTING_CONTEXT_METADATA_KEY = "routing";
    private static final String PATCH_BOLT_METADATA_KEY = "patch_bolt";
    private static final String DATE_TIME_UTC_PATCH_VALUE = "utc";

    public HelloMessage(String userAgent, BoltAgent boltAgent, Map<String, Value> authToken, Map<String, String> routingContext, boolean includeDateTimeUtc, NotificationConfig notificationConfig) {
        super(HelloMessage.buildMetadata(userAgent, boltAgent, authToken, routingContext, includeDateTimeUtc, notificationConfig));
    }

    @Override
    public byte signature() {
        return 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HelloMessage that = (HelloMessage)o;
        return Objects.equals(this.metadata(), that.metadata());
    }

    public int hashCode() {
        return Objects.hash(this.metadata());
    }

    public String toString() {
        HashMap<String, Value> metadataCopy = new HashMap<String, Value>(this.metadata());
        metadataCopy.replace("credentials", Values.value("******"));
        return "HELLO " + metadataCopy;
    }

    private static Map<String, Value> buildMetadata(String userAgent, BoltAgent boltAgent, Map<String, Value> authToken, Map<String, String> routingContext, boolean includeDateTimeUtc, NotificationConfig notificationConfig) {
        HashMap<String, Value> result = new HashMap<String, Value>(authToken);
        if (userAgent != null) {
            result.put(USER_AGENT_METADATA_KEY, Values.value(userAgent));
        }
        if (boltAgent != null) {
            HashMap<String, String> boltAgentMap = new HashMap<String, String>();
            boltAgentMap.put(BOLT_AGENT_PRODUCT_KEY, boltAgent.product());
            if (boltAgent.platform() != null) {
                boltAgentMap.put(BOLT_AGENT_PLATFORM_KEY, boltAgent.platform());
            }
            if (boltAgent.language() != null) {
                boltAgentMap.put(BOLT_AGENT_LANGUAGE_KEY, boltAgent.language());
            }
            if (boltAgent.languageDetails() != null) {
                boltAgentMap.put(BOLT_AGENT_LANGUAGE_DETAIL_KEY, boltAgent.languageDetails());
            }
            result.put(BOLT_AGENT_METADATA_KEY, Values.value(boltAgentMap));
        }
        if (routingContext != null) {
            result.put(ROUTING_CONTEXT_METADATA_KEY, Values.value(routingContext));
        }
        if (includeDateTimeUtc) {
            result.put(PATCH_BOLT_METADATA_KEY, Values.value(Collections.singleton(DATE_TIME_UTC_PATCH_VALUE)));
        }
        MessageWithMetadata.appendNotificationConfig(result, notificationConfig);
        return result;
    }
}

