/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.neo4j.driver.Bookmark;

public final class BookmarkManagerConfig {
    private final Set<Bookmark> initialBookmarks;
    private final Consumer<Set<Bookmark>> bookmarksConsumer;
    private final Supplier<Set<Bookmark>> bookmarksSupplier;

    private BookmarkManagerConfig(BookmarkManagerConfigBuilder builder) {
        this.initialBookmarks = builder.initialBookmarks;
        this.bookmarksConsumer = builder.bookmarksConsumer;
        this.bookmarksSupplier = builder.bookmarksSupplier;
    }

    public static BookmarkManagerConfigBuilder builder() {
        return new BookmarkManagerConfigBuilder();
    }

    public Set<Bookmark> initialBookmarks() {
        return this.initialBookmarks;
    }

    public Optional<Consumer<Set<Bookmark>>> bookmarksConsumer() {
        return Optional.ofNullable(this.bookmarksConsumer);
    }

    public Optional<Supplier<Set<Bookmark>>> bookmarksSupplier() {
        return Optional.ofNullable(this.bookmarksSupplier);
    }

    public static final class BookmarkManagerConfigBuilder {
        private Set<Bookmark> initialBookmarks = Collections.emptySet();
        private Consumer<Set<Bookmark>> bookmarksConsumer;
        private Supplier<Set<Bookmark>> bookmarksSupplier;

        private BookmarkManagerConfigBuilder() {
        }

        public BookmarkManagerConfigBuilder withInitialBookmarks(Set<Bookmark> initialBookmarks) {
            Objects.requireNonNull(initialBookmarks, "initialBookmarks must not be null");
            this.initialBookmarks = initialBookmarks;
            return this;
        }

        public BookmarkManagerConfigBuilder withBookmarksConsumer(Consumer<Set<Bookmark>> bookmarksConsumer) {
            this.bookmarksConsumer = bookmarksConsumer;
            return this;
        }

        public BookmarkManagerConfigBuilder withBookmarksSupplier(Supplier<Set<Bookmark>> bookmarksSupplier) {
            this.bookmarksSupplier = bookmarksSupplier;
            return this;
        }

        public BookmarkManagerConfig build() {
            return new BookmarkManagerConfig(this);
        }
    }
}

