/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.AsValue;
import org.neo4j.driver.internal.value.PathValue;
import org.neo4j.driver.types.Entity;
import org.neo4j.driver.types.Node;
import org.neo4j.driver.types.Path;
import org.neo4j.driver.types.Relationship;

public class InternalPath
implements Path,
AsValue {
    private final List<Node> nodes;
    private final List<Relationship> relationships;
    private final List<Path.Segment> segments;

    private static boolean isEndpoint(Node node, Relationship relationship) {
        return node.id() == relationship.startNodeId() || node.id() == relationship.endNodeId();
    }

    public InternalPath(List<Entity> alternatingNodeAndRel) {
        this.nodes = this.newList(alternatingNodeAndRel.size() / 2 + 1);
        this.relationships = this.newList(alternatingNodeAndRel.size() / 2);
        this.segments = this.newList(alternatingNodeAndRel.size() / 2);
        if (alternatingNodeAndRel.size() % 2 == 0) {
            throw new IllegalArgumentException("An odd number of entities are required to build a path");
        }
        Node lastNode = null;
        Relationship lastRelationship = null;
        int index = 0;
        for (Entity entity : alternatingNodeAndRel) {
            if (entity == null) {
                throw new IllegalArgumentException("Path entities cannot be null");
            }
            if (index % 2 == 0) {
                try {
                    lastNode = (Node)entity;
                    if (!(this.nodes.isEmpty() || lastRelationship != null && InternalPath.isEndpoint(lastNode, lastRelationship))) {
                        throw new IllegalArgumentException("Node argument " + index + " is not an endpoint of relationship argument " + (index - 1));
                    }
                    this.nodes.add(lastNode);
                }
                catch (ClassCastException e) {
                    String cls = entity.getClass().getName();
                    throw new IllegalArgumentException("Expected argument " + index + " to be a node " + index + " but found a " + cls + " instead");
                }
            }
            try {
                lastRelationship = (Relationship)entity;
                if (!InternalPath.isEndpoint(lastNode, lastRelationship)) {
                    throw new IllegalArgumentException("Node argument " + (index - 1) + " is not an endpoint of relationship argument " + index);
                }
                this.relationships.add(lastRelationship);
            }
            catch (ClassCastException e) {
                String cls = entity.getClass().getName();
                throw new IllegalArgumentException("Expected argument " + index + " to be a relationship but found a " + cls + " instead");
            }
            ++index;
        }
        this.buildSegments();
    }

    public InternalPath(Entity ... alternatingNodeAndRel) {
        this(Arrays.asList(alternatingNodeAndRel));
    }

    public InternalPath(List<Path.Segment> segments, List<Node> nodes, List<Relationship> relationships) {
        this.segments = segments;
        this.nodes = nodes;
        this.relationships = relationships;
    }

    private <T> List<T> newList(int size) {
        return size == 0 ? Collections.emptyList() : new ArrayList(size);
    }

    @Override
    public int length() {
        return this.relationships.size();
    }

    @Override
    public boolean contains(Node node) {
        return this.nodes.contains(node);
    }

    @Override
    public boolean contains(Relationship relationship) {
        return this.relationships.contains(relationship);
    }

    @Override
    public Iterable<Node> nodes() {
        return this.nodes;
    }

    @Override
    public Iterable<Relationship> relationships() {
        return this.relationships;
    }

    @Override
    public Node start() {
        return this.nodes.get(0);
    }

    @Override
    public Node end() {
        return this.nodes.get(this.nodes.size() - 1);
    }

    @Override
    public Iterator<Path.Segment> iterator() {
        return this.segments.iterator();
    }

    @Override
    public Value asValue() {
        return new PathValue(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalPath segments1 = (InternalPath)o;
        return this.segments.equals(segments1.segments);
    }

    public int hashCode() {
        return this.segments.hashCode();
    }

    public String toString() {
        return "path" + this.segments;
    }

    private void buildSegments() {
        for (int i = 0; i < this.relationships.size(); ++i) {
            this.segments.add(new SelfContainedSegment(this.nodes.get(i), this.relationships.get(i), this.nodes.get(i + 1)));
        }
    }

    public record SelfContainedSegment(Node start, Relationship relationship, Node end) implements Path.Segment
    {
        @Override
        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            SelfContainedSegment that = (SelfContainedSegment)other;
            return this.start.equals(that.start) && this.end.equals(that.end) && this.relationship.equals(that.relationship);
        }

        @Override
        public String toString() {
            return String.format(this.relationship.startNodeId() == this.start.id() ? "(%s)-[%s:%s]->(%s)" : "(%s)<-[%s:%s]-(%s)", this.start.id(), this.relationship.id(), this.relationship.type(), this.end.id());
        }
    }
}

