/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.driver.NotificationClassification;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.GqlNotificationConfig;
import org.neo4j.driver.internal.InternalNotificationSeverity;
import org.neo4j.driver.internal.messaging.Message;

abstract class MessageWithMetadata
implements Message {
    static final String NOTIFICATIONS_MINIMUM_SEVERITY = "notifications_minimum_severity";
    static final String NOTIFICATIONS_DISABLED_CATEGORIES = "notifications_disabled_categories";
    static final String NOTIFICATIONS_DISABLED_CLASSIFICATIONS = "notifications_disabled_classifications";
    private final Map<String, Value> metadata;

    public MessageWithMetadata(Map<String, Value> metadata) {
        this.metadata = metadata;
    }

    public Map<String, Value> metadata() {
        return this.metadata;
    }

    static void appendNotificationConfig(Map<String, Value> result, GqlNotificationConfig config, boolean legacyNotifications) {
        if (config != null) {
            Set<NotificationClassification> disabledClassifications;
            InternalNotificationSeverity severity = (InternalNotificationSeverity)config.minimumSeverity();
            if (severity != null) {
                result.put(NOTIFICATIONS_MINIMUM_SEVERITY, Values.value(severity.type().toString()));
            }
            if ((disabledClassifications = config.disabledClassifications()) != null) {
                List<String> list = disabledClassifications.stream().map(Object::toString).toList();
                result.put(legacyNotifications ? NOTIFICATIONS_DISABLED_CATEGORIES : NOTIFICATIONS_DISABLED_CLASSIFICATIONS, Values.value(list));
            }
        }
    }
}

