/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v54;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.internal.messaging.AbstractMessageWriter;
import org.neo4j.driver.internal.messaging.MessageEncoder;
import org.neo4j.driver.internal.messaging.common.CommonValuePacker;
import org.neo4j.driver.internal.messaging.encode.BeginMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.CommitMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.DiscardMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.GoodbyeMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.HelloMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.LogoffMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.LogonMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.PullMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.ResetMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RollbackMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RouteV44MessageEncoder;
import org.neo4j.driver.internal.messaging.encode.RunWithMetadataMessageEncoder;
import org.neo4j.driver.internal.messaging.encode.TelemetryMessageEncoder;
import org.neo4j.driver.internal.packstream.PackOutput;
import org.neo4j.driver.internal.util.Iterables;

public class MessageWriterV54
extends AbstractMessageWriter {
    public MessageWriterV54(PackOutput output) {
        super(new CommonValuePacker(output, true), MessageWriterV54.buildEncoders());
    }

    private static Map<Byte, MessageEncoder> buildEncoders() {
        HashMap<Byte, MessageEncoder> result = Iterables.newHashMapWithSize(9);
        result.put((byte)1, new HelloMessageEncoder());
        result.put((byte)106, new LogonMessageEncoder());
        result.put((byte)107, new LogoffMessageEncoder());
        result.put((byte)2, new GoodbyeMessageEncoder());
        result.put((byte)16, new RunWithMetadataMessageEncoder());
        result.put((byte)102, new RouteV44MessageEncoder());
        result.put((byte)47, new DiscardMessageEncoder());
        result.put((byte)63, new PullMessageEncoder());
        result.put((byte)17, new BeginMessageEncoder());
        result.put((byte)18, new CommitMessageEncoder());
        result.put((byte)19, new RollbackMessageEncoder());
        result.put((byte)15, new ResetMessageEncoder());
        result.put((byte)84, new TelemetryMessageEncoder());
        return result;
    }
}

