/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Clause;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.parser.CyperDslParseException;
import org.neo4j.cypherdsl.parser.CypherDslASTExceptionFactory;
import org.neo4j.cypherdsl.parser.CypherDslASTFactory;
import org.neo4j.cypherdsl.parser.NodeAtom;
import org.neo4j.cypherdsl.parser.Options;
import org.neo4j.cypherdsl.parser.UnsupportedCypherException;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.CharStream;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.Cypher;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.CypherCharStream;
import org.neo4j.cypherdsl.parser.internal.parser.javacc.ParseException;

@API(status=API.Status.STABLE, since="2021.3.0")
public final class CypherParser {
    public static Node parseNode(String input) {
        return CypherParser.parseNode(input, Options.defaultOptions());
    }

    public static Node parseNode(String input, Options options) {
        return CypherParser.handle(input, () -> (NodeAtom)new Cypher(CypherDslASTFactory.getInstance(options), CypherDslASTExceptionFactory.INSTANCE, CypherParser.getCharStream(input)).NodePattern()).value();
    }

    public static RelationshipPattern parseRelationship(String input) {
        return CypherParser.parseRelationship(input, Options.defaultOptions());
    }

    public static RelationshipPattern parseRelationship(String input, Options options) {
        return CypherParser.handle(input, () -> (RelationshipPattern)new Cypher(CypherDslASTFactory.getInstance(options), CypherDslASTExceptionFactory.INSTANCE, CypherParser.getCharStream(input)).Pattern());
    }

    public static Expression parseExpression(String input) {
        return CypherParser.parseExpression(input, Options.defaultOptions());
    }

    public static Expression parseExpression(String input, Options options) {
        return CypherParser.handle(input, () -> (Expression)new Cypher(CypherDslASTFactory.getInstance(options), CypherDslASTExceptionFactory.INSTANCE, CypherParser.getCharStream(input)).Expression());
    }

    public static Clause parseClause(String input) {
        return CypherParser.parseClause(input, Options.defaultOptions());
    }

    public static Clause parseClause(String input, Options options) {
        return CypherParser.handle(input, () -> (Clause)new Cypher(CypherDslASTFactory.getInstance(options), CypherDslASTExceptionFactory.INSTANCE, CypherParser.getCharStream(input)).Clause());
    }

    public static Statement parseStatement(String input) {
        return CypherParser.parseStatement(input, Options.defaultOptions());
    }

    public static Statement parseStatement(String input, Options options) {
        return CypherParser.handle(input, () -> (Statement)new Cypher(CypherDslASTFactory.getInstance(options), CypherDslASTExceptionFactory.INSTANCE, CypherParser.getCharStream(input)).Statement());
    }

    public static Statement parse(String input) {
        return CypherParser.parse(input, Options.defaultOptions());
    }

    public static Statement parse(String input, Options options) {
        return CypherParser.parseStatement(input, options);
    }

    private static <T> T handle(String input, ThrowingParser<T> parser) {
        try {
            return parser.parse();
        }
        catch (ParseException e) {
            throw new CyperDslParseException(e);
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedCypherException(input, e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected exception", e);
        }
    }

    private static CharStream getCharStream(String input) {
        return new CypherCharStream(input);
    }

    private CypherParser() {
    }

    @FunctionalInterface
    private static interface ThrowingParser<T> {
        public T parse() throws Exception;
    }
}

