/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.parser;

import org.neo4j.cypherdsl.core.ExposesPatternLengthAccessors;
import org.neo4j.cypherdsl.core.ExposesProperties;
import org.neo4j.cypherdsl.core.ExposesRelationships;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.MapExpression;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.QuantifiedPathPattern;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RelationshipChain;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.parser.NodeAtom;
import org.neo4j.cypherdsl.parser.PathLength;
import org.neo4j.cypherdsl.parser.PatternAtom;

final class PathAtom
implements PatternAtom {
    private final SymbolicName name;
    private final PathLength length;
    private final Relationship.Direction direction;
    private final boolean negatedType;
    private final String[] types;
    private final MapExpression properties;
    private final Expression predicate;
    private final QuantifiedPathPattern.Quantifier quantifier;

    static PathAtom of(SymbolicName name, PathLength length, boolean left, boolean right, String[] relTypes, MapExpression properties, boolean negatedType, Expression predicate) {
        if (left && right) {
            throw new IllegalArgumentException("Only left-to-right, right-to-left or unidirectional path elements are supported.");
        }
        Relationship.Direction direction = left ? Relationship.Direction.RTL : (right ? Relationship.Direction.LTR : Relationship.Direction.UNI);
        return new PathAtom(name, length, direction, negatedType, relTypes, properties, predicate, null);
    }

    private PathAtom(SymbolicName name, PathLength length, Relationship.Direction direction, boolean negatedType, String[] types, MapExpression properties, Expression predicate, QuantifiedPathPattern.Quantifier quantifier) {
        this.name = name;
        this.length = length;
        this.direction = direction;
        this.negatedType = negatedType;
        this.types = types;
        this.properties = properties;
        this.predicate = predicate;
        this.quantifier = quantifier;
    }

    ExposesRelationships<?> asRelationshipBetween(ExposesRelationships<?> previous, NodeAtom nodeAtom, boolean alwaysLtr) {
        Node node = nodeAtom.value();
        ExposesRelationships<?> relationshipPattern = switch (this.getDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case Relationship.Direction.LTR -> previous.relationshipTo(node, this.getTypes());
            case Relationship.Direction.RTL -> {
                if (alwaysLtr) {
                    yield node.relationshipTo((Node)previous, this.getTypes());
                }
                yield previous.relationshipFrom(node, this.getTypes());
            }
            case Relationship.Direction.UNI -> previous.relationshipBetween(node, this.getTypes());
        };
        relationshipPattern = this.applyOptionalName(relationshipPattern);
        relationshipPattern = this.applyOptionalProperties(relationshipPattern);
        relationshipPattern = this.applyOptionalPredicate(relationshipPattern);
        relationshipPattern = this.applyOptionalLength(relationshipPattern);
        return this.applyOptionalQuantifier(relationshipPattern);
    }

    private ExposesRelationships<?> applyOptionalLength(ExposesRelationships<?> relationshipPattern) {
        if (this.length == null) {
            return relationshipPattern;
        }
        if (this.length.isUnbounded()) {
            return ((ExposesPatternLengthAccessors)relationshipPattern).unbounded();
        }
        return ((ExposesPatternLengthAccessors)relationshipPattern).length(this.length.getMinimum(), this.length.getMaximum());
    }

    private ExposesRelationships<?> applyOptionalProperties(ExposesRelationships<?> relationshipPattern) {
        if (this.properties == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof ExposesProperties) {
            ExposesProperties exposesProperties = (ExposesProperties)relationshipPattern;
            return (ExposesRelationships)exposesProperties.withProperties(this.properties);
        }
        return ((RelationshipChain)relationshipPattern).properties(this.properties);
    }

    private ExposesRelationships<?> applyOptionalName(ExposesRelationships<?> relationshipPattern) {
        if (this.name == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof Relationship) {
            Relationship relationship = (Relationship)relationshipPattern;
            return relationship.named(this.name);
        }
        return ((RelationshipChain)relationshipPattern).named(this.name);
    }

    private ExposesRelationships<?> applyOptionalPredicate(ExposesRelationships<?> relationshipPattern) {
        if (this.predicate == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof Relationship) {
            Relationship relationship = (Relationship)relationshipPattern;
            return (ExposesRelationships)relationship.where(this.predicate);
        }
        return ((RelationshipChain)relationshipPattern).where(this.predicate);
    }

    private ExposesRelationships<?> applyOptionalQuantifier(ExposesRelationships<?> relationshipPattern) {
        if (this.quantifier == null) {
            return relationshipPattern;
        }
        if (relationshipPattern instanceof Relationship) {
            Relationship relationship = (Relationship)relationshipPattern;
            return (ExposesRelationships)relationship.quantifyRelationship(this.quantifier);
        }
        return ((RelationshipChain)relationshipPattern).quantifyRelationship(this.quantifier);
    }

    public Relationship.Direction getDirection() {
        return this.direction;
    }

    public String[] getTypes() {
        return this.types;
    }

    public MapExpression getProperties() {
        return this.properties;
    }

    public SymbolicName getName() {
        return this.name;
    }

    public PathAtom withQuantifier(QuantifiedPathPattern.Quantifier newQuantifier) {
        return newQuantifier == null ? this : new PathAtom(this.name, this.length, this.direction, this.negatedType, this.types, this.properties, this.predicate, newQuantifier);
    }
}

