/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import java.io.Serializable;
import java.util.ArrayList;
import org.neo4j.cypherdsl.AsString;
import org.neo4j.cypherdsl.Literal;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.query.clause.Clause;
import org.neo4j.cypherdsl.query.clause.WhereClause;

public class Query
implements AsString,
Serializable,
Cloneable {
    private ArrayList<Clause> clauses = new ArrayList();

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static void checkNull(Object object, String name) {
        if (object.getClass().isArray()) {
            Object[] array;
            for (Object obj : array = (Object[])object) {
                if (obj != null) continue;
                throw new IllegalArgumentException(name + " may not be null");
            }
        } else if (object == null) {
            throw new IllegalArgumentException(name + " may not be null");
        }
    }

    public static void checkEmpty(String string, String name) {
        if (Query.isEmpty(string)) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(Expression value, String name) {
        if (value instanceof Literal && Query.isEmpty(value.toString())) {
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public static void checkEmpty(String[] strings, String name) {
        for (String string : strings) {
            if (!Query.isEmpty(string)) continue;
            throw new IllegalArgumentException(name + " may not be null or empty string");
        }
    }

    public void add(Clause clause) {
        Clause previousClause;
        if (!this.clauses.isEmpty() && clause instanceof WhereClause && (previousClause = this.clauses.get(this.clauses.size() - 1)) instanceof WhereClause) {
            WhereClause previousWhere = (WhereClause)previousClause;
            previousWhere.mergeWith((WhereClause)clause);
            return;
        }
        this.clauses.add(clause);
    }

    @Override
    public void asString(StringBuilder builder) {
        builder.append("CYPHER 1.8");
        for (Clause clause : this.clauses) {
            clause.asString(builder);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        Query query = (Query)super.clone();
        query.clauses = (ArrayList)query.clauses.clone();
        return query;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.asString(builder);
        return builder.toString();
    }
}

