/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.query;

import org.neo4j.cypherdsl.CypherQuery;
import org.neo4j.cypherdsl.expression.BooleanExpression;
import org.neo4j.cypherdsl.expression.CollectionExpression;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.NodeExpression;
import org.neo4j.cypherdsl.expression.NumericExpression;
import org.neo4j.cypherdsl.expression.PathExpression;
import org.neo4j.cypherdsl.expression.RelationshipExpression;
import org.neo4j.cypherdsl.expression.ScalarExpression;
import org.neo4j.cypherdsl.expression.StringExpression;
import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.Operator;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.Regexp;

public class Value
extends AbstractExpression
implements ScalarExpression,
NumericExpression,
StringExpression,
BooleanExpression,
NodeExpression,
RelationshipExpression,
PathExpression,
CollectionExpression {
    public Operator operator;
    public Expression value;

    public Value(Expression value) {
        Query.checkNull(value, "Value");
        this.value = value;
    }

    public Value(Operator operator, Expression value) {
        Query.checkNull(operator, "Operator");
        Query.checkNull(value, "Value");
        this.operator = operator;
        this.value = value;
    }

    @Override
    public NumericExpression add(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "+"), CypherQuery.literal(expression));
    }

    @Override
    public NumericExpression add(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "+"), expression);
    }

    @Override
    public NumericExpression subtract(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "-"), CypherQuery.literal(expression));
    }

    @Override
    public NumericExpression subtract(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "-"), expression);
    }

    @Override
    public NumericExpression times(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "*"), CypherQuery.literal(expression));
    }

    @Override
    public NumericExpression times(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "*"), expression);
    }

    @Override
    public NumericExpression divideBy(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "/"), CypherQuery.literal(expression));
    }

    @Override
    public NumericExpression divideBy(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "/"), expression);
    }

    @Override
    public NumericExpression mod(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "%"), CypherQuery.literal(expression));
    }

    @Override
    public NumericExpression mod(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "%"), expression);
    }

    @Override
    public BooleanExpression gt(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">"), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression lt(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<"), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression gte(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">="), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression lte(Number expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<="), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression gt(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">"), expression);
    }

    @Override
    public BooleanExpression lt(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<"), expression);
    }

    @Override
    public BooleanExpression gte(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">="), expression);
    }

    @Override
    public BooleanExpression lte(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<="), expression);
    }

    @Override
    public BooleanExpression gt(String expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">"), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression gt(StringExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">"), expression);
    }

    @Override
    public BooleanExpression gte(String expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">="), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression gte(StringExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, ">="), expression);
    }

    @Override
    public BooleanExpression lt(String expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<"), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression lt(StringExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<"), expression);
    }

    @Override
    public BooleanExpression lte(String expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<="), CypherQuery.literal(expression));
    }

    @Override
    public BooleanExpression lte(StringExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new Operator(this, "<="), expression);
    }

    @Override
    public BooleanExpression regexp(String regexp) {
        return this.regexp(regexp, true);
    }

    @Override
    public BooleanExpression regexp(StringExpression regexp) {
        return this.regexp(regexp, true);
    }

    @Override
    public BooleanExpression regexp(String regexp, boolean caseSensitive) {
        return this.regexp(CypherQuery.literal(regexp), caseSensitive);
    }

    @Override
    public BooleanExpression regexp(StringExpression regexp, boolean caseSensitive) {
        Regexp regularExpression = new Regexp();
        regularExpression.caseSensitive = caseSensitive;
        regularExpression.left = this;
        regularExpression.regexp = regexp;
        return new Value(regularExpression);
    }

    @Override
    public StringExpression concat(String expression) {
        return new Value(new Operator(this, "+"), CypherQuery.literal(expression));
    }

    @Override
    public StringExpression concat(StringExpression expression) {
        return new Value(new Operator(this, "+"), expression);
    }

    @Override
    public void asString(StringBuilder builder) {
        if (this.operator != null) {
            this.operator.asString(builder);
        }
        this.value.asString(builder);
    }

    @Override
    public String toString() {
        return this.value.toString();
    }
}

