/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.Literal;
import org.neo4j.cypherdsl.Order;
import org.neo4j.cypherdsl.Parameter;
import org.neo4j.cypherdsl.Path;
import org.neo4j.cypherdsl.Property;
import org.neo4j.cypherdsl.SetProperty;
import org.neo4j.cypherdsl.expression.All;
import org.neo4j.cypherdsl.expression.BooleanExpression;
import org.neo4j.cypherdsl.expression.CollectionExpression;
import org.neo4j.cypherdsl.expression.Expression;
import org.neo4j.cypherdsl.expression.NumericExpression;
import org.neo4j.cypherdsl.expression.PathExpression;
import org.neo4j.cypherdsl.expression.PropertyContainerExpression;
import org.neo4j.cypherdsl.expression.ReferenceExpression;
import org.neo4j.cypherdsl.expression.RelationshipExpression;
import org.neo4j.cypherdsl.expression.ScalarExpression;
import org.neo4j.cypherdsl.expression.StartExpression;
import org.neo4j.cypherdsl.expression.StringExpression;
import org.neo4j.cypherdsl.grammar.Create;
import org.neo4j.cypherdsl.grammar.CreateUnique;
import org.neo4j.cypherdsl.grammar.Delete;
import org.neo4j.cypherdsl.grammar.Execute;
import org.neo4j.cypherdsl.grammar.ExecuteWithParameters;
import org.neo4j.cypherdsl.grammar.ForEachStatement;
import org.neo4j.cypherdsl.grammar.ForEachStatements;
import org.neo4j.cypherdsl.grammar.Limit;
import org.neo4j.cypherdsl.grammar.Match;
import org.neo4j.cypherdsl.grammar.OrderBy;
import org.neo4j.cypherdsl.grammar.ReturnNext;
import org.neo4j.cypherdsl.grammar.Set;
import org.neo4j.cypherdsl.grammar.Skip;
import org.neo4j.cypherdsl.grammar.StartNext;
import org.neo4j.cypherdsl.grammar.UpdateNext;
import org.neo4j.cypherdsl.grammar.Where;
import org.neo4j.cypherdsl.grammar.With;
import org.neo4j.cypherdsl.grammar.WithNext;
import org.neo4j.cypherdsl.query.AbstractExpression;
import org.neo4j.cypherdsl.query.ExpressionCollection;
import org.neo4j.cypherdsl.query.Expressions;
import org.neo4j.cypherdsl.query.Extract;
import org.neo4j.cypherdsl.query.Filter;
import org.neo4j.cypherdsl.query.FunctionExpression;
import org.neo4j.cypherdsl.query.IterablePredicateExpression;
import org.neo4j.cypherdsl.query.NamedPath;
import org.neo4j.cypherdsl.query.Operator;
import org.neo4j.cypherdsl.query.OrderByExpression;
import org.neo4j.cypherdsl.query.PropertyValue;
import org.neo4j.cypherdsl.query.Query;
import org.neo4j.cypherdsl.query.SuffixFunctionExpression;
import org.neo4j.cypherdsl.query.Value;
import org.neo4j.cypherdsl.query.clause.CreateClause;
import org.neo4j.cypherdsl.query.clause.CreateUniqueClause;
import org.neo4j.cypherdsl.query.clause.DeleteClause;
import org.neo4j.cypherdsl.query.clause.ForEachClause;
import org.neo4j.cypherdsl.query.clause.LimitClause;
import org.neo4j.cypherdsl.query.clause.LimitParameterClause;
import org.neo4j.cypherdsl.query.clause.MatchClause;
import org.neo4j.cypherdsl.query.clause.OrderByClause;
import org.neo4j.cypherdsl.query.clause.ReturnClause;
import org.neo4j.cypherdsl.query.clause.SetClause;
import org.neo4j.cypherdsl.query.clause.SkipClause;
import org.neo4j.cypherdsl.query.clause.SkipParameterClause;
import org.neo4j.cypherdsl.query.clause.StartClause;
import org.neo4j.cypherdsl.query.clause.WhereClause;
import org.neo4j.cypherdsl.query.clause.WithClause;

public class CypherQuery {
    protected final Query query;

    public static StartNext start(StartExpression ... startExpressions) {
        CypherQuery query = new CypherQuery();
        return query.starts(startExpressions);
    }

    public static UpdateNext create(PathExpression ... paths) {
        CypherQuery query = new CypherQuery();
        return query.creates(paths);
    }

    public static <T> T continueQuery(Query query, Class<T> asClause) throws ClassCastException {
        try {
            return new CypherQuery((Query)query.clone()).continueQuery(asClause);
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public CypherQuery() {
        this.query = new Query();
    }

    private CypherQuery(Query query) {
        try {
            this.query = (Query)query.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Query was not cloneable");
        }
    }

    public static Parameter param(String name) {
        Query.checkEmpty(name, "Name");
        return new Parameter(name);
    }

    public static StringExpression literal(String value) {
        Query.checkNull(value, "Value");
        return new Literal(value);
    }

    public static NumericExpression literal(Number value) {
        Query.checkNull(value, "Value");
        return new Literal(value);
    }

    public static BooleanExpression literal(boolean value) {
        return new Literal(value);
    }

    public static ScalarExpression literal(Object value) {
        Query.checkNull(value, "Value");
        return new Literal(value);
    }

    public static Identifier identifier(String name) {
        Query.checkEmpty(name, "Identifier");
        return new Identifier(name);
    }

    public static CollectionExpression collection(Object ... values) {
        Expression[] expressions = new Expression[values.length];
        for (int i = 0; i < values.length; ++i) {
            Object value = values[i];
            expressions[i] = value instanceof Expression ? (Expression)value : CypherQuery.literal(value);
        }
        return new Value(new ExpressionCollection(new Expressions(expressions)));
    }

    public static Identifier[] identifiers(String ... values) {
        Identifier[] identifiers = new Identifier[values.length];
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            identifiers[i] = CypherQuery.identifier(value);
        }
        return identifiers;
    }

    public static Parameter[] parameters(String ... names) {
        Parameter[] parameters = new Parameter[names.length];
        for (int i = 0; i < names.length; ++i) {
            String value = names[i];
            parameters[i] = CypherQuery.param(value);
        }
        return parameters;
    }

    public static NumericExpression[] literals(long ... values) {
        NumericExpression[] literals = new NumericExpression[values.length];
        for (int i = 0; i < values.length; ++i) {
            long value = values[i];
            literals[i] = CypherQuery.literal(value);
        }
        return literals;
    }

    public static PropertyValue value(String id, Object value) {
        return new PropertyValue(CypherQuery.identifier(id), CypherQuery.literal(value));
    }

    public static PropertyValue value(String id, Expression value) {
        return new PropertyValue(CypherQuery.identifier(id), value);
    }

    public static PropertyValue value(Identifier id, Expression value) {
        return new PropertyValue(id, value);
    }

    public static BooleanExpression and(BooleanExpression ... expressions) {
        Query.checkNull(expressions, "Expressions");
        return new And(expressions);
    }

    public static BooleanExpression or(BooleanExpression ... expressions) {
        Query.checkNull(expressions, "Expressions");
        return new Or(expressions);
    }

    public static BooleanExpression not(BooleanExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("not", expression));
    }

    public static BooleanExpression has(Property property) {
        return new Value(new FunctionExpression("has", property));
    }

    public static BooleanExpression isNull(Expression expression) {
        return new Value(new SuffixFunctionExpression(" is null", expression));
    }

    public static BooleanExpression isNotNull(Expression expression) {
        return new Value(new SuffixFunctionExpression(" is not null", expression));
    }

    protected StartNext starts(StartExpression ... startExpressions) {
        this.query.add(new StartClause(Arrays.asList(startExpressions)));
        return new Grammar();
    }

    protected StartNext starts(Iterable<StartExpression> startExpressions) {
        this.query.add(new StartClause(startExpressions));
        return new Grammar();
    }

    protected UpdateNext creates(PathExpression ... paths) {
        this.query.add(new CreateClause(Arrays.asList(paths)));
        return new Grammar();
    }

    protected <T> T continueQuery(Class<T> asClause) throws ClassCastException {
        return asClause.cast(new Grammar());
    }

    public static StartExpression.StartNodes nodesById(String name, long ... id) {
        return CypherQuery.nodesById(CypherQuery.identifier(name), id);
    }

    public static StartExpression.StartNodes nodesById(Identifier name, long ... id) {
        Query.checkNull(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        return new StartExpression.StartNodes(name, CypherQuery.literals(id));
    }

    @Deprecated
    public static StartExpression.StartNodes nodeByParameter(String name, String parameter) {
        return CypherQuery.nodesByParameter(name, parameter);
    }

    public static StartExpression.StartNodes nodesByParameter(String name, String parameter) {
        return CypherQuery.nodeByparameter(CypherQuery.identifier(name), parameter);
    }

    @Deprecated
    public static StartExpression.StartNodes nodeByparameter(Identifier name, String parameter) {
        return CypherQuery.nodesByParameter(name, parameter);
    }

    public static StartExpression.StartNodes nodesByParameter(Identifier name, String parameter) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(parameter, "Parameters");
        return new StartExpression.StartNodes(name, CypherQuery.parameters(parameter));
    }

    public static StartExpression.StartNodes allNodes(String name) {
        return CypherQuery.allNodes(CypherQuery.identifier(name));
    }

    public static StartExpression.StartNodes allNodes(Identifier name) {
        Query.checkNull(name, "Name");
        return new StartExpression.StartNodes(name, new Expression[]{new StartExpression.AllNodes()});
    }

    public static StartExpression.StartNodesLookup lookup(String name, String indexName, String key, String value) {
        return CypherQuery.lookup(CypherQuery.identifier(name), CypherQuery.identifier(indexName), CypherQuery.identifier(key), CypherQuery.literal(value));
    }

    public static StartExpression.StartNodesLookup lookup(Identifier name, Identifier indexName, ReferenceExpression key, StringExpression value) {
        Query.checkEmpty(name, "Name");
        Query.checkEmpty(indexName, "Index");
        return new StartExpression.StartNodesLookup(name, indexName, key, value);
    }

    public static StartExpression.StartNodesQuery query(String name, String indexName, String query) {
        return CypherQuery.query(CypherQuery.identifier(name), CypherQuery.identifier(indexName), query);
    }

    public static StartExpression.StartNodesQuery query(Identifier name, Identifier indexName, String query) {
        Query.checkNull(name, "Name");
        Query.checkNull(indexName, "Index");
        Query.checkEmpty(query, "Query");
        return new StartExpression.StartNodesQuery(name, indexName, query);
    }

    public static StartExpression.StartNodesQueryParam queryByParameter(String name, String indexName, String param) {
        return CypherQuery.queryByParameter(CypherQuery.identifier(name), CypherQuery.identifier(indexName), param);
    }

    public static StartExpression.StartNodesQueryParam queryByParameter(Identifier name, Identifier indexName, String param) {
        Query.checkNull(name, "Name");
        Query.checkNull(indexName, "Index");
        Query.checkEmpty(param, "Param");
        return new StartExpression.StartNodesQueryParam(name, indexName, param);
    }

    public static StartExpression.StartRelationships relationshipsById(String name, long ... id) {
        return CypherQuery.relationshipsById(CypherQuery.identifier(name), id);
    }

    public static StartExpression.StartRelationships relationshipsById(Identifier name, long ... id) {
        Query.checkNull(name, "Name");
        for (long i : id) {
            if (i >= 0L) continue;
            throw new IllegalArgumentException("Id may not be below zero");
        }
        return new StartExpression.StartRelationships(name, CypherQuery.literals(id));
    }

    public static StartExpression.StartRelationshipsParameters relationshipsByParameter(String name, String parameter) {
        return CypherQuery.relationshipsByParameter(CypherQuery.identifier(name), parameter);
    }

    public static StartExpression.StartRelationshipsParameters relationshipsByParameter(Identifier name, String parameter) {
        Query.checkNull(name, "Name");
        Query.checkEmpty(parameter, "Parameter");
        return new StartExpression.StartRelationshipsParameters(name, parameter);
    }

    public static StartExpression.StartRelationshipsIndex relationshipLookup(String name, String indexName, String key, String value) {
        return CypherQuery.relationshipLookup(CypherQuery.identifier(name), CypherQuery.identifier(indexName), CypherQuery.identifier(key), CypherQuery.literal(value));
    }

    public static StartExpression.StartRelationshipsIndex relationshipLookup(Identifier name, Identifier indexName, Identifier key, StringExpression value) {
        Query.checkNull(name, "Name");
        Query.checkNull(indexName, "Index");
        Query.checkNull(key, "Key");
        Query.checkNull(value, "Value");
        return new StartExpression.StartRelationshipsIndex(name, indexName, key, value);
    }

    public static Path node() {
        return new Path(null, null, null);
    }

    public static Path node(String id) {
        return CypherQuery.node(CypherQuery.identifier(id));
    }

    public static Path node(Expression expression) {
        return new Path(expression, null, null);
    }

    public static PathExpression path(String name, PathExpression path) {
        return CypherQuery.path(CypherQuery.identifier(name), path);
    }

    public static PathExpression path(Identifier name, PathExpression path) {
        Query.checkNull(name, "Name");
        return new NamedPath(name, path);
    }

    public static PathExpression shortestPath(PathExpression path) {
        Query.checkNull(path, "Path");
        return new Value(new FunctionExpression("shortestPath", path));
    }

    public static PathExpression allShortestPaths(PathExpression path) {
        Query.checkNull(path, "Path");
        return new Value(new FunctionExpression("allShortestPaths", path));
    }

    public static Expression as(Expression expression, String name) {
        return new Value(new Operator(expression, " AS "), CypherQuery.identifier(name));
    }

    public static Expression as(Expression expression, Identifier name) {
        return new Value(new Operator(expression, " AS "), name);
    }

    public static Expression distinct(Expression expression) {
        return new Value(new Operator("DISTINCT "), expression);
    }

    public static NumericExpression count() {
        return new Value(new FunctionExpression("count", new AbstractExpression(){

            @Override
            public void asString(StringBuilder builder) {
                builder.append('*');
            }
        }));
    }

    public static NumericExpression count(Expression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("count", expression));
    }

    public static All all() {
        return new All();
    }

    public static NumericExpression sum(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("sum", expression));
    }

    public static NumericExpression avg(Expression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("avg", expression));
    }

    public static NumericExpression max(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("max", expression));
    }

    public static NumericExpression min(NumericExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("min", expression));
    }

    public static CollectionExpression collect(ScalarExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("collect", expression));
    }

    public static OrderByExpression order(Expression expression) {
        Query.checkNull(expression, "Expression");
        return new OrderByExpression(expression, null);
    }

    public static OrderByExpression order(Expression expression, Order order) {
        Query.checkNull(expression, "Name");
        Query.checkNull((Object)order, "Order");
        return new OrderByExpression(expression, order);
    }

    public static ForEachStatements in(String id, Expression in) {
        return new ForEachClause(CypherQuery.identifier(id), in);
    }

    public static ForEachStatements in(Identifier id, Expression in) {
        return new ForEachClause(id, in);
    }

    public static SetProperty property(Property property, Expression value) {
        return new SetProperty(property, value);
    }

    public static BooleanExpression all(String name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        return CypherQuery.all(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static BooleanExpression all(Identifier name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        return new Value(new IterablePredicateExpression("all", name, iterable, predicateExpression));
    }

    public static BooleanExpression any(String name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        return CypherQuery.any(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static BooleanExpression any(Identifier name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        return new Value(new IterablePredicateExpression("any", name, iterable, predicateExpression));
    }

    public static BooleanExpression none(String name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        return CypherQuery.none(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static BooleanExpression none(Identifier name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        return new Value(new IterablePredicateExpression("none", name, iterable, predicateExpression));
    }

    public static BooleanExpression single(String name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        return CypherQuery.single(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static BooleanExpression single(Identifier name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        return new Value(new IterablePredicateExpression("single", name, iterable, predicateExpression));
    }

    public static NumericExpression length(CollectionExpression expression) {
        Query.checkNull(expression, "Expression");
        return new Value(new FunctionExpression("length", expression));
    }

    public static StringExpression type(RelationshipExpression relationshipExpression) {
        Query.checkNull(relationshipExpression, "Expression");
        return new Value(new FunctionExpression("type", relationshipExpression));
    }

    public static NumericExpression id(String name) {
        Query.checkNull(name, "Name");
        return new Value(new FunctionExpression("id", CypherQuery.identifier(name)));
    }

    public static NumericExpression id(PropertyContainerExpression propertyContainerExpression) {
        Query.checkNull(propertyContainerExpression, "Expression");
        return new Value(new FunctionExpression("id", propertyContainerExpression));
    }

    public static Value coalesce(Expression ... expressions) {
        if (expressions.length < 1) {
            throw new IllegalArgumentException("At least one expression must be provided to coalesce function");
        }
        return new Value(new FunctionExpression("coalesce", new Expressions(expressions)));
    }

    public static Expression head(CollectionExpression collectionExpression) {
        Query.checkNull(collectionExpression, "Expression");
        return new Value(new FunctionExpression("head", collectionExpression));
    }

    public static Expression last(CollectionExpression collectionExpression) {
        Query.checkNull(collectionExpression, "Expression");
        return new Value(new FunctionExpression("last", collectionExpression));
    }

    public static CollectionExpression nodes(PathExpression pathExpression) {
        Query.checkNull(pathExpression, "Expression");
        return new Value(new FunctionExpression("nodes", pathExpression));
    }

    public static CollectionExpression relationships(PathExpression pathExpression) {
        Query.checkNull(pathExpression, "Expression");
        return new Value(new FunctionExpression("relationships", pathExpression));
    }

    public static CollectionExpression extract(String name, CollectionExpression iterable, ScalarExpression expression) {
        return CypherQuery.extract(CypherQuery.identifier(name), iterable, expression);
    }

    public static CollectionExpression extract(Identifier name, CollectionExpression iterable, ScalarExpression expression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(expression, "Expression");
        return new Value(new Extract(name, iterable, expression));
    }

    public static CollectionExpression filter(String name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        return CypherQuery.filter(CypherQuery.identifier(name), iterable, predicateExpression);
    }

    public static CollectionExpression filter(Identifier name, CollectionExpression iterable, BooleanExpression predicateExpression) {
        Query.checkNull(name, "Name");
        Query.checkNull(iterable, "Iterable");
        Query.checkNull(predicateExpression, "Predicate");
        return new Value(new Filter(name, iterable, predicateExpression));
    }

    public static CollectionExpression tail(CollectionExpression collectionExpression) {
        Query.checkNull(collectionExpression, "Expression");
        return new Value(new FunctionExpression("tail", collectionExpression));
    }

    public static CollectionExpression range(Number start, Number end) {
        return CypherQuery.range(CypherQuery.literal(start), CypherQuery.literal(end), null);
    }

    public static CollectionExpression range(Number start, Number end, Number step) {
        return CypherQuery.range(CypherQuery.literal(start), CypherQuery.literal(end), CypherQuery.literal(step));
    }

    public static CollectionExpression range(NumericExpression start, NumericExpression end) {
        return CypherQuery.range(start, end, null);
    }

    public static CollectionExpression range(NumericExpression start, NumericExpression end, NumericExpression step) {
        if (step == null) {
            return new Value(new FunctionExpression("range", new Expressions(new Expression[]{start, end})));
        }
        return new Value(new FunctionExpression("range", new Expressions(new Expression[]{start, end, step})));
    }

    public static NumericExpression p(NumericExpression numericExpression) {
        return new Value(new FunctionExpression("", numericExpression));
    }

    public static NumericExpression abs(Number numericalExpression) {
        return CypherQuery.abs(CypherQuery.literal(numericalExpression));
    }

    public static NumericExpression abs(NumericExpression numericalExpression) {
        return new Value(new FunctionExpression("abs", numericalExpression));
    }

    public static NumericExpression round(Number numericalExpression) {
        return CypherQuery.round(CypherQuery.literal(numericalExpression));
    }

    public static NumericExpression round(NumericExpression numericalExpression) {
        return new Value(new FunctionExpression("round", numericalExpression));
    }

    public static NumericExpression sqrt(Number numericalExpression) {
        return CypherQuery.sqrt(CypherQuery.literal(numericalExpression));
    }

    public static NumericExpression sqrt(NumericExpression numericalExpression) {
        return new Value(new FunctionExpression("sqrt", numericalExpression));
    }

    public static NumericExpression sign(Number numericalExpression) {
        return CypherQuery.sign(CypherQuery.literal(numericalExpression));
    }

    public static NumericExpression sign(NumericExpression numericalExpression) {
        return new Value(new FunctionExpression("sign", numericalExpression));
    }

    public String toString() {
        return this.query.toString();
    }

    public static class Or
    extends Value {
        public Or(BooleanExpression[] value) {
            super(new Expressions(value));
        }

        @Override
        public void asString(StringBuilder builder) {
            Expressions expressions = (Expressions)this.value;
            for (int i = 0; i < expressions.expressions.length; ++i) {
                Expression expression = expressions.expressions[i];
                if (i > 0) {
                    builder.append(" or ");
                }
                if (expression instanceof And) {
                    builder.append('(');
                    expression.asString(builder);
                    builder.append(')');
                    continue;
                }
                expression.asString(builder);
            }
        }
    }

    public static class And
    extends Value {
        public And(BooleanExpression[] value) {
            super(new Expressions(value));
        }

        @Override
        public void asString(StringBuilder builder) {
            Expressions expressions = (Expressions)this.value;
            for (int i = 0; i < expressions.expressions.length; ++i) {
                Expression expression = expressions.expressions[i];
                if (i > 0) {
                    builder.append(" and ");
                }
                if (expression instanceof And || expression instanceof Or) {
                    builder.append('(');
                    expression.asString(builder);
                    builder.append(')');
                    continue;
                }
                expression.asString(builder);
            }
        }
    }

    protected class ExecuteWithParams
    implements ExecuteWithParameters {
        private final Query query;
        private final Map<String, Object> parameters = new HashMap<String, Object>();

        public ExecuteWithParams(Query query) {
            this.query = query;
        }

        @Override
        public Query toQuery() {
            return this.query;
        }

        @Override
        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            this.parameters.put(name, value);
            return this;
        }

        @Override
        public ExecuteWithParameters parameters(Map<String, Object> parameters) {
            parameters.putAll(parameters);
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            this.query.asString(builder);
        }

        public String toString() {
            return this.query.toString();
        }
    }

    protected class Grammar
    implements StartNext,
    With,
    WithNext,
    Create,
    Set,
    Delete,
    CreateUnique,
    UpdateNext,
    Match,
    ReturnNext,
    OrderBy,
    Skip,
    Limit,
    Execute {
        protected Grammar() {
        }

        @Override
        public WithNext with(Expression ... withExpressions) {
            CypherQuery.this.query.add(new WithClause(Arrays.asList(withExpressions)));
            return this;
        }

        @Override
        public WithNext with(Iterable<Expression> withExpressions) {
            CypherQuery.this.query.add(new WithClause(withExpressions));
            return this;
        }

        @Override
        public UpdateNext create(PathExpression ... paths) {
            CypherQuery.this.query.add(new CreateClause(Arrays.asList(paths)));
            return this;
        }

        @Override
        public UpdateNext create(Iterable<PathExpression> paths) {
            CypherQuery.this.query.add(new CreateClause(paths));
            return this;
        }

        @Override
        public UpdateNext set(SetProperty ... setProperties) {
            CypherQuery.this.query.add(new SetClause(Arrays.asList(setProperties)));
            return this;
        }

        @Override
        public UpdateNext set(Iterable<SetProperty> setProperties) {
            CypherQuery.this.query.add(new SetClause(setProperties));
            return this;
        }

        @Override
        public UpdateNext delete(ReferenceExpression ... expressions) {
            CypherQuery.this.query.add(new DeleteClause(Arrays.asList(expressions)));
            return this;
        }

        @Override
        public UpdateNext delete(Iterable<ReferenceExpression> expressions) {
            CypherQuery.this.query.add(new DeleteClause(expressions));
            return this;
        }

        @Override
        public UpdateNext createUnique(PathExpression ... expressions) {
            CypherQuery.this.query.add(new CreateUniqueClause(Arrays.asList(expressions)));
            return this;
        }

        @Override
        public UpdateNext createUnique(Iterable<PathExpression> expressions) {
            CypherQuery.this.query.add(new CreateUniqueClause(expressions));
            return this;
        }

        @Override
        public UpdateNext forEach(ForEachStatement statement) {
            CypherQuery.this.query.add(statement.getClause());
            return this;
        }

        @Override
        public StartNext starts(StartExpression ... startExpression) {
            CypherQuery.this.query.add(new StartClause(Arrays.asList(startExpression)));
            return this;
        }

        @Override
        public StartNext starts(Iterable<StartExpression> startExpression) {
            CypherQuery.this.query.add(new StartClause(startExpression));
            return this;
        }

        @Override
        public Match match(PathExpression ... expressions) {
            CypherQuery.this.query.add(new MatchClause(Arrays.asList(expressions)));
            return this;
        }

        @Override
        public Match match(Iterable<PathExpression> expressions) {
            CypherQuery.this.query.add(new MatchClause(expressions));
            return this;
        }

        @Override
        public Where where(BooleanExpression expression) {
            Query.checkNull(expression, "Expression");
            CypherQuery.this.query.add(new WhereClause(expression));
            return this;
        }

        @Override
        public ReturnNext returns(Expression ... returnExpressions) {
            CypherQuery.this.query.add(new ReturnClause(Arrays.asList(returnExpressions)));
            return this;
        }

        @Override
        public ReturnNext returns(Iterable<Expression> returnExpressions) {
            CypherQuery.this.query.add(new ReturnClause(returnExpressions));
            return this;
        }

        @Override
        public OrderBy orderBy(Expression ... orderByExpressions) {
            CypherQuery.this.query.add(new OrderByClause(Arrays.asList(orderByExpressions)));
            return this;
        }

        @Override
        public OrderBy orderBy(Iterable<Expression> orderByExpressions) {
            CypherQuery.this.query.add(new OrderByClause(orderByExpressions));
            return this;
        }

        @Override
        public Limit skip(int skip) {
            if (skip < 0) {
                throw new IllegalArgumentException("Skip may not be below zero");
            }
            CypherQuery.this.query.add(new SkipClause(skip));
            return this;
        }

        @Override
        public Limit skip(String skip) {
            CypherQuery.this.query.add(new SkipParameterClause(skip));
            return this;
        }

        @Override
        public Execute limit(int limit) {
            if (limit < 0) {
                throw new IllegalArgumentException("Limit may not be below zero");
            }
            CypherQuery.this.query.add(new LimitClause(limit));
            return this;
        }

        @Override
        public Execute limit(String limit) {
            CypherQuery.this.query.add(new LimitParameterClause(limit));
            return this;
        }

        @Override
        public void asString(StringBuilder builder) {
            CypherQuery.this.query.asString(builder);
        }

        @Override
        public Query toQuery() {
            return CypherQuery.this.query;
        }

        @Override
        public ExecuteWithParameters parameter(String name, Object value) {
            ExecuteWithParams withParams = new ExecuteWithParams(CypherQuery.this.query);
            return withParams.parameter(name, value);
        }

        @Override
        public ExecuteWithParameters parameters(Map<String, Object> parameters) {
            ExecuteWithParams withParams = new ExecuteWithParams(CypherQuery.this.query);
            withParams.getParameters().putAll(parameters);
            return withParams;
        }

        public String toString() {
            return CypherQuery.this.toString();
        }
    }
}

