/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl;

import org.neo4j.cypherdsl.Identifier;
import org.neo4j.cypherdsl.expression.ReferenceExpression;
import org.neo4j.cypherdsl.query.NullHandling;
import org.neo4j.cypherdsl.query.Operator;
import org.neo4j.cypherdsl.query.Value;

public class Property
extends Value
implements ReferenceExpression {
    protected final NullHandling nullHandling;
    private final Identifier owner;
    private final Identifier name;

    Property(Identifier owner, Identifier name, NullHandling nullHandling) {
        super(new Operator(owner, "."), name);
        this.nullHandling = nullHandling;
        this.owner = owner;
        this.name = name;
    }

    public Property falseIfMissing() {
        return new Property(this.owner, this.name, NullHandling.FALSE_IF_MISSING);
    }

    public Property trueIfMissing() {
        return new Property(this.owner, this.name, NullHandling.TRUE_IF_MISSING);
    }

    public Property optional() {
        return this.trueIfMissing();
    }

    @Override
    public void asString(StringBuilder builder) {
        super.asString(builder);
        NullHandling nullHandling1 = this.nullHandling;
        nullHandling1.asString(builder);
    }
}

