/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.AbstractPropertyContainer;
import org.neo4j.cypherdsl.core.AliasedExpression;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Functions;
import org.neo4j.cypherdsl.core.HasLabelCondition;
import org.neo4j.cypherdsl.core.InternalRelationshipImpl;
import org.neo4j.cypherdsl.core.Node;
import org.neo4j.cypherdsl.core.Relationship;
import org.neo4j.cypherdsl.core.RendererBridge;
import org.neo4j.cypherdsl.core.SortItem;

@API(status=API.Status.INTERNAL, since="2021.1.0")
abstract class AbstractNode
extends AbstractPropertyContainer
implements Node {
    AbstractNode() {
    }

    @Override
    @NotNull
    public final Condition hasLabels(String ... labelsToQuery) {
        return HasLabelCondition.create(this.getSymbolicName().orElseThrow(() -> new IllegalStateException("Cannot query a node without a symbolic name.")), labelsToQuery);
    }

    @Override
    @NotNull
    public final Condition isEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isEqualTo(otherNode.getRequiredSymbolicName());
    }

    @Override
    @NotNull
    public final Condition isNotEqualTo(Node otherNode) {
        return this.getRequiredSymbolicName().isNotEqualTo(otherNode.getRequiredSymbolicName());
    }

    @Override
    @NotNull
    public final Condition isNull() {
        return this.getRequiredSymbolicName().isNull();
    }

    @Override
    @NotNull
    public final Condition isNotNull() {
        return this.getRequiredSymbolicName().isNotNull();
    }

    @Override
    @NotNull
    public final SortItem descending() {
        return this.getRequiredSymbolicName().descending();
    }

    @Override
    @NotNull
    public final SortItem ascending() {
        return this.getRequiredSymbolicName().ascending();
    }

    @Override
    @NotNull
    public final AliasedExpression as(String alias) {
        return this.getRequiredSymbolicName().as(alias);
    }

    @Override
    @NotNull
    public final FunctionInvocation internalId() {
        return Functions.id(this);
    }

    @Override
    @NotNull
    public final FunctionInvocation labels() {
        return Functions.labels(this);
    }

    @Override
    @NotNull
    public final Relationship relationshipTo(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.LTR, other, types);
    }

    @Override
    @NotNull
    public final Relationship relationshipFrom(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.RTL, other, types);
    }

    @Override
    @NotNull
    public final Relationship relationshipBetween(Node other, String ... types) {
        return new InternalRelationshipImpl(null, (Node)this, Relationship.Direction.UNI, other, types);
    }

    @Override
    public String toString() {
        return RendererBridge.render(this);
    }
}

