/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.executables;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apiguardian.api.API;
import org.jetbrains.annotations.NotNull;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.executables.ExecutableStatement;
import org.neo4j.driver.Query;
import org.neo4j.driver.SimpleQueryRunner;
import org.neo4j.driver.async.AsyncQueryRunner;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.summary.ResultSummary;

@API(status=API.Status.INTERNAL, since="2021.2.1")
class DefaultExecutableStatement
implements ExecutableStatement {
    private final Statement delegate;

    DefaultExecutableStatement(Statement delegate) {
        this.delegate = delegate;
    }

    @Override
    @NotNull
    public final Map<String, Object> getParameters() {
        return this.delegate.getCatalog().getParameters();
    }

    @Override
    @NotNull
    public final Collection<String> getParameterNames() {
        return this.delegate.getCatalog().getParameterNames();
    }

    @Override
    @NotNull
    public final String getCypher() {
        return this.delegate.getCypher();
    }

    @Override
    public final ResultSummary executeWith(SimpleQueryRunner queryRunner) {
        return queryRunner.run(this.createQuery()).consume();
    }

    @Override
    public final CompletableFuture<ResultSummary> executeWith(AsyncQueryRunner queryRunner) {
        return queryRunner.runAsync(this.createQuery()).thenCompose(ResultCursor::consumeAsync).toCompletableFuture();
    }

    final Query createQuery() {
        return new Query(this.delegate.getCypher(), this.getParameters());
    }
}

