/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core.renderer;

import java.util.Optional;
import java.util.function.Function;
import org.apiguardian.api.API;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Comparison;
import org.neo4j.cypherdsl.core.FunctionInvocation;
import org.neo4j.cypherdsl.core.Subquery;
import org.neo4j.cypherdsl.core.With;
import org.neo4j.cypherdsl.core.ast.Visitable;
import org.neo4j.cypherdsl.core.ast.Visitor;
import org.neo4j.cypherdsl.core.renderer.Neo4j523SubqueryVisitor;
import org.neo4j.cypherdsl.core.renderer.Neo4j5ComparisonVisitor;
import org.neo4j.cypherdsl.core.renderer.Neo4j5FunctionInvocationVisitor;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@API(status=API.Status.STABLE, since="2022.3.0")
public enum Dialect {
    NEO4J_4,
    NEO4J_5{
        private final DefaultNeo4j5HandlerSupplier handlerSupplier = new DefaultNeo4j5HandlerSupplier();

        @Override
        @Nullable
        Class<? extends Visitor> getHandler(Visitable visitable) {
            return this.handlerSupplier.apply(visitable).orElseGet(() -> super.getHandler(visitable));
        }
    }
    ,
    NEO4J_5_23{
        private final DefaultNeo4j5HandlerSupplier handlerSupplier = new DefaultNeo4j5HandlerSupplierWithNewImportScopeSubquerySupport();

        @Override
        @Nullable
        Class<? extends Visitor> getHandler(Visitable visitable) {
            return this.handlerSupplier.apply(visitable).orElseGet(() -> super.getHandler(visitable));
        }
    }
    ,
    NEO4J_5_26{
        private final DefaultNeo4j5HandlerSupplier handlerSupplier = new DefaultNeo4j5HandlerSupplierWithNewImportScopeSubquerySupport();

        @Override
        @Nullable
        Class<? extends Visitor> getHandler(Visitable visitable) {
            return this.handlerSupplier.apply(visitable).orElseGet(() -> super.getHandler(visitable));
        }

        @Override
        Optional<String> getPrefix() {
            return Optional.of("CYPHER 5 ");
        }
    };


    @Nullable
    Class<? extends Visitor> getHandler(Visitable visitable) {
        return null;
    }

    Optional<String> getPrefix() {
        return Optional.empty();
    }

    private static class DefaultNeo4j5HandlerSupplierWithNewImportScopeSubquerySupport
    extends DefaultNeo4j5HandlerSupplier {
        private DefaultNeo4j5HandlerSupplierWithNewImportScopeSubquerySupport() {
        }

        @Override
        public Optional<Class<? extends Visitor>> apply(Visitable visitable) {
            return super.apply(visitable).or(() -> {
                if (visitable instanceof Subquery || visitable instanceof With) {
                    return Optional.of(Neo4j523SubqueryVisitor.class);
                }
                return Optional.empty();
            });
        }
    }

    private static class DefaultNeo4j5HandlerSupplier
    implements Function<Visitable, Optional<Class<? extends Visitor>>> {
        private DefaultNeo4j5HandlerSupplier() {
        }

        @Override
        public Optional<Class<? extends Visitor>> apply(Visitable visitable) {
            if (visitable instanceof FunctionInvocation) {
                return Optional.of(Neo4j5FunctionInvocationVisitor.class);
            }
            if (visitable instanceof Comparison) {
                return Optional.of(Neo4j5ComparisonVisitor.class);
            }
            return Optional.empty();
        }
    }
}

