/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.jdbc.bolt.impl;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.neo4j.driver.AuthToken;
import org.neo4j.driver.AuthTokens;
import org.neo4j.driver.Config;
import org.neo4j.driver.Driver;
import org.neo4j.jdbc.Neo4jDriver;
import org.neo4j.jdbc.bolt.BoltNeo4jConnection;
import org.neo4j.jdbc.bolt.impl.BoltNeo4jConnectionImpl;

public abstract class BoltNeo4jDriverImpl
extends Neo4jDriver {
    public static final String TRUST_STRATEGY_KEY = "trust.strategy";
    public static final String TRUSTED_CERTIFICATE_KEY = "trusted.certificate.file";
    public static final String CONNECTION_ACQUISITION_TIMEOUT = "connection.acquisition.timeout";
    public static final String CONNECTION_LIVENESS_CHECK_TIMEOUT = "connection.liveness.check.timeout";
    public static final String CONNECTION_TIMEOUT = "connection.timeout";
    public static final String ENCRYPTION = "encryption";
    public static final String LEAKED_SESSIONS_LOGGING = "leaked.sessions.logging";
    public static final String MAX_CONNECTION_LIFETIME = "max.connection.lifetime";
    public static final String MAX_CONNECTION_POOLSIZE = "max.connection.poolsize";
    public static final String MAX_TRANSACTION_RETRY_TIME = "max.transaction.retry.time";
    public static final String DATABASE = "database";

    protected BoltNeo4jDriverImpl(String prefix) {
        super(prefix);
    }

    public Connection connect(String url, Properties props) throws SQLException {
        if (url == null) {
            throw new SQLException("null is not a valid url");
        }
        BoltNeo4jConnection connection = null;
        if (this.acceptsURL(url)) {
            String boltUrl = url.replace("jdbc:neo4j:", "").replaceAll("^(" + this.getPrefix() + ":)([^/])", "$1//$2");
            Driver driver = null;
            try {
                Properties info = this.mergeUrlAndInfo(boltUrl, props);
                boltUrl = this.removeUrlProperties(boltUrl);
                Config.ConfigBuilder builder = Config.builder();
                if (info.containsKey("nossl")) {
                    builder = builder.withoutEncryption();
                }
                builder = this.setTrustStrategy(info, builder);
                builder = this.setConnectionAcquisitionTimeout(info, builder);
                builder = this.setIdleTimeBeforeConnectionTest(info, builder);
                builder = this.setConnectionTimeout(info, builder);
                builder = this.setEncryption(info, builder);
                builder = this.setLakedSessionLogging(info, builder);
                builder = this.setMaxConnectionLifetime(info, builder);
                builder = this.setMaxConnectionPoolSize(info, builder);
                builder = this.setMaxTransactionRetryTime(info, builder);
                Config config = builder.build();
                AuthToken authToken = this.getAuthToken(info);
                Properties routingContext = this.getRoutingContext(boltUrl, info);
                boltUrl = this.addRoutingPolicy(boltUrl, routingContext);
                List<URI> routingUris = this.buildRoutingUris(boltUrl, routingContext);
                driver = this.getDriver(routingUris, config, authToken, info);
                driver.verifyConnectivity();
                connection = BoltNeo4jConnectionImpl.newInstance(driver, info, url);
            }
            catch (Exception e) {
                if (driver != null) {
                    try {
                        driver.close();
                    }
                    catch (Exception closeException) {
                        e.addSuppressed(closeException);
                    }
                }
                throw new SQLException(e);
            }
        }
        return connection;
    }

    protected abstract Driver getDriver(List<URI> var1, Config var2, AuthToken var3, Properties var4) throws URISyntaxException;

    private AuthToken getAuthToken(Properties properties) {
        if (!properties.containsKey("user")) {
            if (properties.containsKey("password")) {
                return AuthTokens.basic((String)"neo4j", (String)properties.getProperty("password"));
            }
            return AuthTokens.none();
        }
        return AuthTokens.basic((String)properties.getProperty("user"), (String)properties.getProperty("password"));
    }

    private String removeUrlProperties(String url) {
        String boltUrl = url;
        if (boltUrl.indexOf(63) != -1) {
            boltUrl = url.substring(0, url.indexOf(63));
        }
        return boltUrl;
    }

    protected abstract Properties getRoutingContext(String var1, Properties var2);

    protected abstract String addRoutingPolicy(String var1, Properties var2);

    protected abstract List<URI> buildRoutingUris(String var1, Properties var2) throws URISyntaxException;

    private Config.ConfigBuilder setTrustStrategy(Properties properties, Config.ConfigBuilder builder) throws SQLException {
        Config.ConfigBuilder newBuilder = builder;
        if (properties.containsKey(TRUST_STRATEGY_KEY)) {
            Config.TrustStrategy.Strategy strategy;
            try {
                strategy = Config.TrustStrategy.Strategy.valueOf((String)((String)properties.get(TRUST_STRATEGY_KEY)));
            }
            catch (IllegalArgumentException e) {
                throw new SQLException("Invalid value for trust.strategy param.", e);
            }
            switch (strategy) {
                case TRUST_SYSTEM_CA_SIGNED_CERTIFICATES: {
                    newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustSystemCertificates());
                    break;
                }
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    newBuilder = this.handleTrustStrategyWithFile(properties, strategy, builder);
                    break;
                }
                default: {
                    newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustAllCertificates());
                }
            }
        }
        return newBuilder;
    }

    protected Properties mergeUrlAndInfo(String url, Properties params) {
        Properties fromInput = params == null ? new Properties() : params;
        Properties fromUrl = super.parseUrlProperties(url, null);
        Properties merge = (Properties)fromInput.clone();
        Set<String> keys = fromUrl.stringPropertyNames();
        for (String key : keys) {
            merge.put(key, fromUrl.get(key));
        }
        this.setUserInfo(merge);
        return merge;
    }

    protected void setUserInfo(Properties properties) {
        String user = properties.getProperty("username");
        if (user == null) {
            user = properties.getProperty("user");
        }
        if (user != null && !user.trim().isEmpty()) {
            properties.setProperty("user", user);
        }
    }

    private Config.ConfigBuilder handleTrustStrategyWithFile(Properties properties, Config.TrustStrategy.Strategy strategy, Config.ConfigBuilder builder) throws SQLException {
        if (properties.containsKey(TRUSTED_CERTIFICATE_KEY)) {
            Config.ConfigBuilder newBuilder;
            switch (strategy) {
                case TRUST_CUSTOM_CA_SIGNED_CERTIFICATES: {
                    String value = properties.getProperty(TRUSTED_CERTIFICATE_KEY);
                    newBuilder = builder.withTrustStrategy(Config.TrustStrategy.trustCustomCertificateSignedBy((File[])new File[]{new File(value)}));
                    break;
                }
                default: {
                    newBuilder = builder;
                }
            }
            return newBuilder;
        }
        throw new SQLException("Missing parameter 'trusted.certificate.file' : A FILE IS REQUIRED");
    }

    private Config.ConfigBuilder setValueConfig(Properties info, Config.ConfigBuilder builder, String key, Function<String, Config.ConfigBuilder> op, String errorMessage) {
        if (info.containsKey(key)) {
            String value = info.getProperty(key);
            try {
                return op.apply(value);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(key + ": " + value + " " + errorMessage);
            }
        }
        return builder;
    }

    private Config.ConfigBuilder setLongConfig(Properties info, Config.ConfigBuilder builder, String key, Function<Long, Config.ConfigBuilder> op) {
        return this.setValueConfig(info, builder, key, val -> (Config.ConfigBuilder)op.apply(Long.parseLong(val)), "is not a number");
    }

    private Config.ConfigBuilder setBooleanConfig(Properties info, Config.ConfigBuilder builder, String key, Function<Boolean, Config.ConfigBuilder> op) {
        return this.setValueConfig(info, builder, key, val -> {
            if ("true".equalsIgnoreCase((String)val) || "false".equalsIgnoreCase((String)val)) {
                return (Config.ConfigBuilder)op.apply(Boolean.parseBoolean(val));
            }
            throw new IllegalArgumentException();
        }, "is not a boolean");
    }

    private Config.ConfigBuilder setConnectionAcquisitionTimeout(Properties info, Config.ConfigBuilder builder) {
        return this.setLongConfig(info, builder, CONNECTION_ACQUISITION_TIMEOUT, ms -> builder.withConnectionAcquisitionTimeout(ms.longValue(), TimeUnit.MILLISECONDS));
    }

    private Config.ConfigBuilder setIdleTimeBeforeConnectionTest(Properties info, Config.ConfigBuilder builder) {
        return this.setLongConfig(info, builder, CONNECTION_LIVENESS_CHECK_TIMEOUT, ms -> builder.withConnectionLivenessCheckTimeout(ms.longValue(), TimeUnit.MINUTES));
    }

    private Config.ConfigBuilder setConnectionTimeout(Properties info, Config.ConfigBuilder builder) {
        return this.setLongConfig(info, builder, CONNECTION_TIMEOUT, ms -> builder.withConnectionTimeout(ms.longValue(), TimeUnit.MILLISECONDS));
    }

    private Config.ConfigBuilder setEncryption(Properties info, Config.ConfigBuilder builder) {
        return this.setBooleanConfig(info, builder, ENCRYPTION, condition -> condition != false ? builder.withEncryption() : builder.withoutEncryption());
    }

    private Config.ConfigBuilder setLakedSessionLogging(Properties info, Config.ConfigBuilder builder) {
        return this.setBooleanConfig(info, builder, LEAKED_SESSIONS_LOGGING, condition -> condition != false ? builder.withLeakedSessionsLogging() : builder);
    }

    private Config.ConfigBuilder setMaxConnectionLifetime(Properties info, Config.ConfigBuilder builder) {
        return this.setLongConfig(info, builder, MAX_CONNECTION_LIFETIME, ms -> builder.withMaxConnectionLifetime(ms.longValue(), TimeUnit.MILLISECONDS));
    }

    private Config.ConfigBuilder setMaxConnectionPoolSize(Properties info, Config.ConfigBuilder builder) {
        return this.setValueConfig(info, builder, MAX_CONNECTION_POOLSIZE, val -> builder.withMaxConnectionPoolSize(Integer.parseInt(val)), "is not a number");
    }

    private Config.ConfigBuilder setMaxTransactionRetryTime(Properties info, Config.ConfigBuilder builder) {
        return this.setLongConfig(info, builder, MAX_TRANSACTION_RETRY_TIME, ms -> builder.withMaxTransactionRetryTime(ms.longValue(), TimeUnit.MILLISECONDS));
    }
}

