/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import java.util.ArrayList;
import java.util.List;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.kernel.TransactionEventHandlers;
import org.neo4j.kernel.impl.core.NodeManager;

public class TransactionEventsSyncHook
implements Synchronization {
    private final TransactionEventHandlers handlers;
    private final NodeManager nodeManager;
    private List<TransactionEventHandlers.HandlerAndState> states;
    private TransactionData transactionData;
    private final TransactionManager tm;

    public TransactionEventsSyncHook(NodeManager nodeManager, TransactionEventHandlers transactionEventHandlers, TransactionManager tm) {
        this.nodeManager = nodeManager;
        this.handlers = transactionEventHandlers;
        this.tm = tm;
    }

    public void beforeCompletion() {
        this.transactionData = this.nodeManager.getTransactionData();
        try {
            if (this.tm.getStatus() != 0) {
                return;
            }
        }
        catch (SystemException e) {
            e.printStackTrace();
        }
        this.states = new ArrayList<TransactionEventHandlers.HandlerAndState>();
        this.handlers.beforeCompletion(this.transactionData, this.states);
    }

    public void afterCompletion(int status) {
        this.handlers.afterCompletion(this.transactionData, status, this.states);
    }
}

