/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;

public class XaLogicalLogFiles {
    private static final String ACTIVE_FILE_SUFFIX = ".active";
    private static final String LOG_2_SUFFIX = ".2";
    private static final String LOG_1_SUFFIX = ".1";
    private String fileName;
    private FileSystemAbstraction fileSystem;

    public XaLogicalLogFiles(String fileName, FileSystemAbstraction fileSystem) {
        this.fileName = fileName;
        this.fileSystem = fileSystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State determineState() throws IOException {
        String activeFileName = this.fileName + ACTIVE_FILE_SUFFIX;
        if (!this.fileSystem.fileExists(activeFileName)) {
            if (this.fileSystem.fileExists(this.fileName)) {
                return State.LEGACY_WITHOUT_LOG_ROTATION;
            }
            return State.NO_ACTIVE_FILE;
        }
        FileChannel fc = null;
        byte[] bytes = new byte[256];
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        int read = 0;
        try {
            fc = this.fileSystem.open(activeFileName, "rw");
            read = fc.read(buf);
        }
        finally {
            if (fc != null) {
                fc.close();
            }
        }
        if (read != 4) {
            throw new IllegalStateException("Read " + read + " bytes from " + activeFileName + " but expected 4");
        }
        buf.flip();
        char c = buf.asCharBuffer().get();
        if (c == 'C') {
            return State.CLEAN;
        }
        if (c == '1') {
            if (!this.fileSystem.fileExists(this.getLog1FileName())) {
                throw new IllegalStateException("Active marked as 1 but no " + this.getLog1FileName() + " exist");
            }
            if (this.fileSystem.fileExists(this.getLog2FileName())) {
                return State.DUAL_LOGS_LOG_1_ACTIVE;
            }
            return State.LOG_1_ACTIVE;
        }
        if (c == '2') {
            if (!this.fileSystem.fileExists(this.getLog2FileName())) {
                throw new IllegalStateException("Active marked as 2 but no " + this.getLog2FileName() + " exist");
            }
            if (this.fileSystem.fileExists(this.getLog1FileName())) {
                return State.DUAL_LOGS_LOG_2_ACTIVE;
            }
            return State.LOG_2_ACTIVE;
        }
        throw new IllegalStateException("Unknown active log: " + c);
    }

    public String getLog1FileName() {
        return this.fileName + LOG_1_SUFFIX;
    }

    public String getLog2FileName() {
        return this.fileName + LOG_2_SUFFIX;
    }

    public static enum State {
        LEGACY_WITHOUT_LOG_ROTATION,
        NO_ACTIVE_FILE,
        CLEAN,
        LOG_1_ACTIVE,
        LOG_2_ACTIVE,
        DUAL_LOGS_LOG_1_ACTIVE,
        DUAL_LOGS_LOG_2_ACTIVE;

    }
}

