/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.service;

import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.config.CompilerConfiguration;
import org.neo4j.ogm.exception.ServiceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class CompilerService {
    private static final Logger logger = LoggerFactory.getLogger(CompilerService.class);

    CompilerService() {
    }

    private static Compiler load(String className) {
        for (Compiler compiler : ServiceLoader.load(Compiler.class)) {
            try {
                if (!compiler.getClass().getName().equals(className)) continue;
                return compiler;
            }
            catch (ServiceConfigurationError sce) {
                logger.warn("{}, reason: {}", (Object)sce.getLocalizedMessage(), (Object)sce.getCause());
            }
        }
        throw new ServiceNotFoundException("Compiler: " + className);
    }

    public static Compiler load(CompilerConfiguration configuration) {
        String compilerClassName = configuration.getCompilerClassName();
        return CompilerService.load(compilerClassName);
    }
}

