/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.service;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.neo4j.ogm.autoindex.AutoIndexMode;
import org.neo4j.ogm.classloader.ClassLoaderResolver;
import org.neo4j.ogm.compiler.Compiler;
import org.neo4j.ogm.config.Configuration;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.service.CompilerService;
import org.neo4j.ogm.service.DriverService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Components {
    private static final Logger logger = LoggerFactory.getLogger(Components.class);
    private static Configuration configuration = new Configuration();
    private static Driver driver;

    private Components() {
    }

    public static void configure(Configuration configuration) {
        if (Components.configuration != configuration) {
            Components.destroy();
            Components.configuration = configuration;
        } else if (driver != null && !driver.getClass().getCanonicalName().equals(configuration.driverConfiguration().getDriverClassName())) {
            driver.close();
            driver = null;
        }
    }

    public static void configure(String configurationFileName) {
        try (InputStream is = Components.toInputStream(configurationFileName);){
            Components.configure(is);
        }
        catch (Exception e) {
            logger.warn("Could not configure OGM from {}", (Object)configurationFileName);
        }
    }

    public static synchronized Driver driver() {
        if (driver == null) {
            Components.loadDriver();
        }
        return driver;
    }

    public static synchronized Compiler compiler() {
        return Components.getCompiler();
    }

    public static synchronized void autoConfigure() {
        try (InputStream is = Components.configurationFile();){
            Components.configure(is);
        }
        catch (Exception e) {
            logger.warn("Could not autoconfigure the OGM");
        }
    }

    private static void configure(InputStream is) throws Exception {
        Components.destroy();
        Properties properties = new Properties();
        properties.load(is);
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            configuration.set(propertyName, properties.getProperty(propertyName));
        }
    }

    private static void loadDriver() {
        if (configuration.driverConfiguration().getDriverClassName() == null) {
            Components.autoConfigure();
        }
        Components.setDriver(DriverService.load(configuration.driverConfiguration()));
    }

    private static Compiler getCompiler() {
        if (configuration.compilerConfiguration().getCompilerClassName() == null) {
            Components.autoConfigure();
        }
        return CompilerService.load(configuration.compilerConfiguration());
    }

    private static InputStream configurationFile() {
        String configFileName = System.getenv("ogm.properties");
        if (configFileName == null && (configFileName = System.getProperty("ogm.properties")) == null) {
            return Components.toInputStream("ogm.properties");
        }
        return Components.toInputStream(configFileName);
    }

    private static InputStream toInputStream(String name) {
        logger.debug("Trying to configure from {} ", (Object)name);
        return ClassLoaderResolver.resolve().getResourceAsStream(name);
    }

    public static void setDriver(Driver driver) {
        logger.debug("Setting driver to: {}", (Object)driver.getClass().getName());
        if (Components.driver != null && Components.driver != driver) {
            Components.driver.close();
            Components.getConfiguration().driverConfiguration().setDriverClassName(driver.getClass().getCanonicalName());
        }
        Components.driver = driver;
    }

    public static double neo4jVersion() {
        String neo4jVersion = (String)configuration.get("neo4j.version");
        if (neo4jVersion != null) {
            try {
                String[] versionElements = neo4jVersion.split("\\.");
                if (versionElements.length < 2) {
                    throw new NumberFormatException();
                }
                return new Double(versionElements[0] + "." + versionElements[1]);
            }
            catch (NumberFormatException nfe) {
                logger.warn("Configuration property 'neo4j.version' is not in the correct form: expected something like '2.3', but got '{}' instead", (Object)neo4jVersion);
            }
        }
        return 9.9;
    }

    public static synchronized void destroy() {
        if (driver != null) {
            driver.close();
            driver = null;
        }
        configuration.clear();
    }

    public static AutoIndexMode autoIndexMode() {
        return configuration.autoIndexConfiguration().getAutoIndex();
    }

    public static Configuration getConfiguration() {
        return configuration;
    }
}

