/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.autoindex;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.autoindex.AutoIndex;
import org.neo4j.ogm.autoindex.AutoIndexMode;
import org.neo4j.ogm.autoindex.MissingIndexException;
import org.neo4j.ogm.autoindex.Neo4jVersionException;
import org.neo4j.ogm.driver.Driver;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.model.RowModel;
import org.neo4j.ogm.request.DefaultRequest;
import org.neo4j.ogm.request.Statement;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.service.Components;
import org.neo4j.ogm.session.request.RowDataStatement;
import org.neo4j.ogm.session.transaction.DefaultTransactionManager;
import org.neo4j.ogm.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoIndexManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassInfo.class);
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    private final List<AutoIndex> indexes;
    private final AutoIndexMode mode;
    private final Driver driver;

    public AutoIndexManager(MetaData metaData, Driver driver) {
        this.driver = this.initialiseDriver(driver);
        this.mode = Components.autoIndexMode();
        this.indexes = this.initialiseIndexMetadata(metaData);
    }

    private Driver initialiseDriver(Driver driver) {
        driver.setTransactionManager((TransactionManager)new DefaultTransactionManager(null, driver));
        return driver;
    }

    private List<AutoIndex> initialiseIndexMetadata(MetaData metaData) {
        LOGGER.debug("Building Index Metadata.");
        ArrayList<AutoIndex> indexMetadata = new ArrayList<AutoIndex>();
        for (ClassInfo classInfo : metaData.persistentEntities()) {
            if (!classInfo.containsIndexes()) continue;
            for (FieldInfo fieldInfo : classInfo.getIndexFields()) {
                AutoIndex index = new AutoIndex(classInfo.neo4jName(), fieldInfo.property(), fieldInfo.isConstraint());
                LOGGER.debug("Adding Index [description={}]", (Object)index);
                indexMetadata.add(index);
            }
        }
        return indexMetadata;
    }

    public List<AutoIndex> getIndexes() {
        return this.indexes;
    }

    public void build() {
        switch (this.mode) {
            case ASSERT: {
                this.assertIndexes();
                break;
            }
            case VALIDATE: {
                this.validateIndexes();
                break;
            }
            case DUMP: {
                this.dumpIndexes();
            }
        }
    }

    private void dumpIndexes() {
        String newLine = System.lineSeparator();
        StringBuilder sb = new StringBuilder();
        for (AutoIndex index : this.indexes) {
            sb.append(index.getCreateStatement().getStatement()).append(newLine);
        }
        File file = new File(Components.getConfiguration().autoIndexConfiguration().getDumpDir(), Components.getConfiguration().autoIndexConfiguration().getDumpFilename());
        FileWriter writer = null;
        LOGGER.debug("Dumping Indexes to: [{}]", (Object)file.toString());
        try {
            writer = new FileWriter(file);
            writer.write(sb.toString());
        }
        catch (IOException e) {
            throw new RuntimeException("Could not write file to " + file.getAbsolutePath());
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void validateIndexes() {
        LOGGER.debug("Validating Indexes");
        org.neo4j.ogm.session.request.DefaultRequest indexRequests = this.buildProcedures();
        ArrayList<AutoIndex> copyOfIndexes = new ArrayList<AutoIndex>(this.indexes);
        try (Response response = this.driver.request().execute((DefaultRequest)indexRequests);){
            RowModel rowModel;
            while ((rowModel = (RowModel)response.next()) != null) {
                if (rowModel.getValues().length == 3 && rowModel.getValues()[2].equals("node_unique_property")) continue;
                for (AutoIndex index : this.indexes) {
                    if (!index.getDescription().replaceAll("\\s+", "").equalsIgnoreCase(((String)rowModel.getValues()[0]).replaceAll("\\s+", ""))) continue;
                    copyOfIndexes.remove(index);
                }
            }
        }
        if (!copyOfIndexes.isEmpty()) {
            String missingIndexes = "[";
            for (AutoIndex s : copyOfIndexes) {
                missingIndexes = missingIndexes + s.getDescription() + ", ";
            }
            missingIndexes = missingIndexes + "]";
            throw new MissingIndexException("Validation of Constraints and Indexes failed. Could not find the following : " + missingIndexes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertIndexes() {
        LOGGER.debug("Asserting Indexes.");
        org.neo4j.ogm.session.request.DefaultRequest indexRequests = this.buildProcedures();
        ArrayList<Statement> dropStatements = new ArrayList<Statement>();
        try (Response response = this.driver.request().execute((DefaultRequest)indexRequests);){
            RowModel rowModel;
            while ((rowModel = (RowModel)response.next()) != null) {
                if (rowModel.getValues().length == 3 && rowModel.getValues()[2].equals("node_unique_property")) continue;
                String dropStatement = "DROP " + rowModel.getValues()[0];
                LOGGER.debug("[{}] added to drop statements.", (Object)dropStatement);
                dropStatements.add(new RowDataStatement(dropStatement, EMPTY_MAP));
            }
        }
        org.neo4j.ogm.session.request.DefaultRequest dropIndexesRequest = new org.neo4j.ogm.session.request.DefaultRequest();
        dropIndexesRequest.setStatements(dropStatements);
        LOGGER.debug("Dropping all indexes and constraints");
        Response response = this.driver.request().execute((DefaultRequest)dropIndexesRequest);
        Throwable throwable = null;
        if (response != null) {
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                response.close();
            }
        }
        this.create();
    }

    private org.neo4j.ogm.session.request.DefaultRequest buildProcedures() {
        if (Components.neo4jVersion() < 3.0) {
            throw new Neo4jVersionException("This configuration of auto indexing requires Neo4j version 3.0 or higher.");
        }
        ArrayList<Statement> procedures = new ArrayList<Statement>();
        procedures.add(new RowDataStatement("CALL db.constraints()", EMPTY_MAP));
        procedures.add(new RowDataStatement("CALL db.indexes()", EMPTY_MAP));
        org.neo4j.ogm.session.request.DefaultRequest getIndexesRequest = new org.neo4j.ogm.session.request.DefaultRequest();
        getIndexesRequest.setStatements(procedures);
        return getIndexesRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void create() {
        block6: {
            ArrayList<Statement> statements = new ArrayList<Statement>();
            for (AutoIndex index : this.indexes) {
                Statement createStatement = index.getCreateStatement();
                LOGGER.debug("[{}] added to create statements.", (Object)createStatement);
                statements.add(createStatement);
            }
            org.neo4j.ogm.session.request.DefaultRequest request = new org.neo4j.ogm.session.request.DefaultRequest();
            request.setStatements(statements);
            LOGGER.debug("Creating indexes and constraints.");
            Response response = this.driver.request().execute((DefaultRequest)request);
            Throwable throwable = null;
            if (response == null) break block6;
            if (throwable != null) {
                try {
                    response.close();
                }
                catch (Throwable x2) {
                    throwable.addSuppressed(x2);
                }
            } else {
                response.close();
            }
        }
    }
}

