/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.context;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.MetaData;
import org.neo4j.ogm.context.GraphEntityMapper;
import org.neo4j.ogm.context.ResponseMapper;
import org.neo4j.ogm.context.RestStatisticsModel;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.model.RestModel;
import org.neo4j.ogm.response.Response;
import org.neo4j.ogm.response.model.DefaultGraphModel;
import org.neo4j.ogm.response.model.NodeModel;
import org.neo4j.ogm.response.model.RelationshipModel;
import org.neo4j.ogm.session.Utils;

public class RestModelMapper
implements ResponseMapper<RestModel> {
    final GraphEntityMapper graphEntityMapper;
    final MetaData metaData;

    public RestModelMapper(GraphEntityMapper graphEntityMapper, MetaData metaData) {
        this.graphEntityMapper = graphEntityMapper;
        this.metaData = metaData;
    }

    public <T> Iterable<T> map(Class<T> type, Response<RestModel> response) {
        RestStatisticsModel restStatisticsModel = new RestStatisticsModel();
        RestModel model = (RestModel)response.next();
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        HashMap<Long, String> relationshipEntityColumns = new HashMap<Long, String>();
        restStatisticsModel.setStatistics(model.getStats());
        while (model.getRow().entrySet().size() > 0) {
            Map row = model.getRow();
            ArrayList<RelationshipModel> relationshipModels = new ArrayList<RelationshipModel>();
            for (Map.Entry<String, Object> entry : row.entrySet()) {
                Object mapped;
                Object value = entry.getValue();
                if (value instanceof List) {
                    List entityList = (List)value;
                    if (this.isMappable(entityList)) {
                        for (int i = 0; i < entityList.size(); ++i) {
                            Object mapped2 = this.mapEntity(entry.getKey(), entityList.get(i), relationshipModels, relationshipEntityColumns);
                            if (mapped2 == null) continue;
                            entityList.set(i, mapped2);
                        }
                        continue;
                    }
                    this.convertListValueToArray(entityList, entry);
                    continue;
                }
                if (!this.isMappable(Collections.singletonList(value)) || (mapped = this.mapEntity((String)entry.getKey(), value, relationshipModels, relationshipEntityColumns)) == null) continue;
                entry.setValue(mapped);
            }
            DefaultGraphModel graphModel = new DefaultGraphModel();
            graphModel.setRelationships(relationshipModels.toArray(new RelationshipModel[relationshipModels.size()]));
            Map<Long, Object> map = this.graphEntityMapper.mapRelationships((GraphModel)graphModel);
            for (Map.Entry<Long, Object> entry : map.entrySet()) {
                Object rels = row.get(relationshipEntityColumns.get(entry.getKey()));
                if (rels instanceof List) {
                    List relsList = (List)rels;
                    for (int i = 0; i < relsList.size(); ++i) {
                        if (!(relsList.get(i) instanceof RelationshipModel) || !((RelationshipModel)relsList.get(i)).getId().equals(entry.getKey())) continue;
                        relsList.set(i, entry.getValue());
                    }
                    continue;
                }
                row.put(relationshipEntityColumns.get(entry.getKey()), entry.getValue());
            }
            result.add(row);
            model = (RestModel)response.next();
        }
        restStatisticsModel.setResult(result);
        return Collections.singletonList(restStatisticsModel);
    }

    private void convertListValueToArray(List entityList, Map.Entry<String, Object> entry) {
        Class<?> arrayClass = null;
        for (Object element : entityList) {
            Class<?> clazz = element.getClass();
            if (arrayClass == null) {
                arrayClass = clazz;
                continue;
            }
            if (arrayClass == clazz) continue;
            arrayClass = null;
            break;
        }
        if (arrayClass == null) {
            entry.setValue(entityList.toArray());
        } else {
            Object array = Array.newInstance(arrayClass, entityList.size());
            for (int j = 0; j < entityList.size(); ++j) {
                Array.set(array, j, Utils.coerceTypes(arrayClass, entityList.get(j)));
            }
            entry.setValue(array);
        }
    }

    private boolean isMappable(List entityList) {
        if (entityList.size() > 0) {
            for (Object entityObj : entityList) {
                if (entityObj instanceof NodeModel || entityObj instanceof RelationshipModel) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Object mapEntity(String column, Object entity, List<RelationshipModel> relationshipModels, Map<Long, String> relationshipEntityColumns) {
        if (entity instanceof NodeModel) {
            NodeModel nodeModel = (NodeModel)entity;
            DefaultGraphModel graphModel = new DefaultGraphModel();
            graphModel.setNodes(new NodeModel[]{nodeModel});
            if (nodeModel.getLabels() != null && this.metaData.resolve(nodeModel.getLabels()) != null) {
                List mapped = this.graphEntityMapper.map(this.metaData.resolve(nodeModel.getLabels()).getUnderlyingClass(), (GraphModel)graphModel);
                return mapped.get(0);
            }
        } else if (entity instanceof RelationshipModel) {
            RelationshipModel relationshipModel = (RelationshipModel)entity;
            relationshipModels.add(relationshipModel);
            ClassInfo classInfo = this.metaData.classInfo(relationshipModel.getType());
            if (classInfo != null && classInfo.isRelationshipEntity()) {
                relationshipEntityColumns.put(relationshipModel.getId(), column);
            }
        }
        return null;
    }
}

