/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.exception.MappingException;
import org.neo4j.ogm.metadata.AnnotationInfo;
import org.neo4j.ogm.metadata.ClassFileProcessor;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.neo4j.ogm.metadata.InterfaceInfo;
import org.neo4j.ogm.metadata.MethodInfo;
import org.neo4j.ogm.scanner.ClassPathScanner;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.neo4j.ogm.typeconversion.ConversionCallbackRegistry;
import org.neo4j.ogm.typeconversion.ConvertibleTypes;
import org.neo4j.ogm.typeconversion.ProxyAttributeConverter;
import org.neo4j.ogm.utils.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainInfo
implements ClassFileProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassFileProcessor.class);
    private static final String dateSignature = "java/util/Date";
    private static final String bigDecimalSignature = "java/math/BigDecimal";
    private static final String bigIntegerSignature = "java/math/BigInteger";
    private static final String byteArraySignature = "[B";
    private static final String byteArrayWrapperSignature = "[Ljava/lang/Byte";
    private static final String arraySignature = "[L";
    private static final String collectionSignature = "L";
    private final List<String> classPaths = new ArrayList<String>();
    private final Map<String, ClassInfo> classNameToClassInfo = new HashMap<String, ClassInfo>();
    private final Map<String, ArrayList<ClassInfo>> annotationNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Map<String, ArrayList<ClassInfo>> interfaceNameToClassInfo = new HashMap<String, ArrayList<ClassInfo>>();
    private final Set<Class> enumTypes = new HashSet<Class>();
    private final ConversionCallbackRegistry conversionCallbackRegistry = new ConversionCallbackRegistry();

    public DomainInfo(String ... packages) {
        long startTime = System.nanoTime();
        this.load(packages);
        LOGGER.info("{} classes loaded in {} nanoseconds", (Object)this.classNameToClassInfo.entrySet().size(), (Object)(System.nanoTime() - startTime));
    }

    public DomainInfo(Class ... classes) {
        long startTime = System.nanoTime();
        this.load(classes);
        LOGGER.info("{} classes loaded in {} nanoseconds", (Object)this.classNameToClassInfo.entrySet().size(), (Object)(System.nanoTime() - startTime));
    }

    private void buildAnnotationNameToClassInfoMap() {
        LOGGER.info("Building annotation class map");
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            for (AnnotationInfo annotation : classInfo.annotations()) {
                ArrayList<ClassInfo> classInfoList = this.annotationNameToClassInfo.get(annotation.getName());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.annotationNameToClassInfo.put(annotation.getName(), classInfoList);
                }
                classInfoList.add(classInfo);
            }
        }
    }

    private void buildInterfaceNameToClassInfoMap() {
        LOGGER.info("Building interface class map for {} classes", (Object)this.classNameToClassInfo.values().size());
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            LOGGER.debug(" - {} implements {} interfaces", (Object)classInfo.simpleName(), (Object)classInfo.interfacesInfo().list().size());
            for (InterfaceInfo iface : classInfo.interfacesInfo().list()) {
                ArrayList<ClassInfo> classInfoList = this.interfaceNameToClassInfo.get(iface.name());
                if (classInfoList == null) {
                    classInfoList = new ArrayList();
                    this.interfaceNameToClassInfo.put(iface.name(), classInfoList);
                }
                LOGGER.debug("   - {}", (Object)iface.name());
                classInfoList.add(classInfo);
            }
        }
    }

    public void registerConversionCallback(ConversionCallback conversionCallback) {
        this.conversionCallbackRegistry.registerConversionCallback(conversionCallback);
    }

    @Override
    public void finish() {
        LOGGER.info("Starting Post-processing phase");
        this.buildAnnotationNameToClassInfoMap();
        this.buildInterfaceNameToClassInfoMap();
        ArrayList<ClassInfo> transientClasses = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            if (classInfo.name() == null || classInfo.name().equals("java.lang.Object")) continue;
            LOGGER.debug("Post-processing: {}", (Object)classInfo.name());
            if (classInfo.isTransient()) {
                LOGGER.debug(" - Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
                continue;
            }
            if (classInfo.superclassName() == null || classInfo.superclassName().equals("java.lang.Object")) {
                this.extend(classInfo, classInfo.directSubclasses());
            }
            for (InterfaceInfo interfaceInfo : classInfo.interfacesInfo().list()) {
                this.implement(classInfo, interfaceInfo);
            }
        }
        LOGGER.debug("Checking for @Transient classes....");
        Collection<ArrayList<ClassInfo>> interfaceInfos = this.interfaceNameToClassInfo.values();
        for (ArrayList<ClassInfo> classInfos : interfaceInfos) {
            for (ClassInfo classInfo : classInfos) {
                if (!classInfo.isTransient()) continue;
                LOGGER.debug("Registering @Transient baseclass: {}", (Object)classInfo.name());
                transientClasses.add(classInfo);
            }
        }
        HashSet<Class> transientClassesRemoved = new HashSet<Class>();
        for (ClassInfo transientClass : transientClasses) {
            transientClassesRemoved.addAll(this.removeTransientClass(transientClass));
        }
        LOGGER.debug("Registering converters and deregistering transient fields and methods....");
        this.postProcessFields(transientClassesRemoved);
        this.postProcessMethods(transientClassesRemoved);
        LOGGER.info("Post-processing complete");
    }

    private void postProcessFields(Set<Class> transientClassesRemoved) {
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            boolean registerConverters = false;
            if (!classInfo.isEnum() && !classInfo.isInterface()) {
                registerConverters = true;
            }
            Iterator<FieldInfo> fieldInfoIterator = classInfo.fieldsInfo().fields().iterator();
            while (fieldInfoIterator.hasNext()) {
                FieldInfo fieldInfo = fieldInfoIterator.next();
                if (!fieldInfo.persistableAsProperty()) {
                    Class<?> fieldClass = null;
                    try {
                        fieldClass = ClassUtils.getType(fieldInfo.getTypeDescriptor());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Unable to compute class type for " + classInfo.name() + ", field: " + fieldInfo.getName());
                    }
                    if (fieldClass != null && transientClassesRemoved.contains(fieldClass)) {
                        fieldInfoIterator.remove();
                        continue;
                    }
                }
                if (!registerConverters) continue;
                this.registerDefaultFieldConverters(classInfo, fieldInfo);
            }
        }
    }

    private void postProcessMethods(Set<Class> transientClassesRemoved) {
        for (ClassInfo classInfo : this.classNameToClassInfo.values()) {
            boolean registerConverters = false;
            if (!classInfo.isEnum() && !classInfo.isInterface()) {
                registerConverters = true;
            }
            Iterator<MethodInfo> methodInfoIterator = classInfo.methodsInfo().methods().iterator();
            while (methodInfoIterator.hasNext()) {
                MethodInfo methodInfo = methodInfoIterator.next();
                if (!methodInfo.isSimpleGetter() && !methodInfo.isSimpleSetter()) {
                    Class<?> methodClass = null;
                    try {
                        methodClass = ClassUtils.getType(methodInfo.getTypeDescriptor());
                    }
                    catch (Exception e) {
                        LOGGER.debug("Unable to compute class type for " + classInfo.name() + ", method: " + methodInfo.getName());
                    }
                    if (methodClass != null && transientClassesRemoved.contains(methodClass)) {
                        methodInfoIterator.remove();
                        classInfo.methodsInfo().removeGettersAndSetters(methodInfo);
                        continue;
                    }
                }
                if (!registerConverters) continue;
                this.registerDefaultMethodConverters(classInfo, methodInfo);
            }
        }
    }

    private Set<Class> removeTransientClass(ClassInfo transientClass) {
        HashSet<Class> removed = new HashSet<Class>();
        if (transientClass != null && !transientClass.name().equals("java.lang.Object")) {
            LOGGER.debug("Removing @Transient class: {}", (Object)transientClass.name());
            this.classNameToClassInfo.remove(transientClass.name());
            removed.add(transientClass.getUnderlyingClass());
            for (ClassInfo transientChild : transientClass.directSubclasses()) {
                this.removeTransientClass(transientChild);
            }
            for (ClassInfo transientChild : transientClass.directImplementingClasses()) {
                this.removeTransientClass(transientChild);
            }
        }
        return removed;
    }

    private void extend(ClassInfo superclass, List<ClassInfo> subclasses) {
        for (ClassInfo subclass : subclasses) {
            subclass.extend(superclass);
            this.extend(subclass, subclass.directSubclasses());
        }
    }

    private void implement(ClassInfo implementingClass, InterfaceInfo interfaceInfo) {
        ClassInfo interfaceClass = this.classNameToClassInfo.get(interfaceInfo.name());
        if (interfaceClass != null) {
            if (!implementingClass.directInterfaces().contains(interfaceClass)) {
                LOGGER.debug(" - Setting {} implements {}", (Object)implementingClass.simpleName(), (Object)interfaceClass.simpleName());
                implementingClass.directInterfaces().add(interfaceClass);
            }
            if (!interfaceClass.directImplementingClasses().contains(implementingClass)) {
                interfaceClass.directImplementingClasses().add(implementingClass);
            }
            for (ClassInfo subClassInfo : implementingClass.directSubclasses()) {
                this.implement(subClassInfo, interfaceInfo);
            }
        } else {
            LOGGER.debug(" - No ClassInfo found for interface class: {}", (Object)interfaceInfo.name());
        }
    }

    @Override
    public void process(InputStream inputStream) throws IOException {
        ClassInfo classInfo = new ClassInfo(inputStream);
        String className = classInfo.name();
        String superclassName = classInfo.superclassName();
        LOGGER.debug("Processing: {} -> {}", (Object)className, (Object)superclassName);
        if (className != null) {
            ClassInfo thisClassInfo = this.classNameToClassInfo.get(className);
            if (thisClassInfo == null) {
                thisClassInfo = classInfo;
                this.classNameToClassInfo.put(className, thisClassInfo);
            }
            if (!thisClassInfo.hydrated()) {
                thisClassInfo.hydrate(classInfo);
                ClassInfo superclassInfo = this.classNameToClassInfo.get(superclassName);
                if (superclassInfo == null) {
                    this.classNameToClassInfo.put(superclassName, new ClassInfo(superclassName, thisClassInfo));
                } else {
                    superclassInfo.addSubclass(thisClassInfo);
                }
            }
            if (thisClassInfo.isEnum()) {
                LOGGER.debug("Registering enum class: {}", (Object)thisClassInfo.name());
                this.enumTypes.add(thisClassInfo.getUnderlyingClass());
            }
        }
    }

    private void load(Class ... classes) {
        this.classPaths.clear();
        this.classNameToClassInfo.clear();
        this.annotationNameToClassInfo.clear();
        this.interfaceNameToClassInfo.clear();
        for (Class clazz : classes) {
            URL resource = clazz.getResource(clazz.getSimpleName() + ".class");
            try (InputStream inputStream = resource.openStream();){
                this.process(inputStream);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void load(String ... packages) {
        this.classPaths.clear();
        this.classNameToClassInfo.clear();
        this.annotationNameToClassInfo.clear();
        this.interfaceNameToClassInfo.clear();
        for (String packageName : packages) {
            String path = packageName.replace(".", "/");
            if (!path.endsWith("/")) {
                path = path.concat("/");
            }
            this.classPaths.add(path);
        }
        new ClassPathScanner().scan(this.classPaths, this);
    }

    public ClassInfo getClass(String fqn) {
        return this.classNameToClassInfo.get(fqn);
    }

    public ClassInfo getClassSimpleName(String fullOrPartialClassName) {
        return this.getClassInfo(fullOrPartialClassName, this.classNameToClassInfo);
    }

    public ClassInfo getClassInfoForInterface(String fullOrPartialClassName) {
        ClassInfo classInfo = this.getClassSimpleName(fullOrPartialClassName);
        if (classInfo != null && classInfo.isInterface()) {
            return classInfo;
        }
        return null;
    }

    private ClassInfo getClassInfo(String fullOrPartialClassName, Map<String, ClassInfo> infos) {
        ClassInfo match = null;
        for (String fqn : infos.keySet()) {
            if (!fqn.endsWith("." + fullOrPartialClassName) && !fqn.equals(fullOrPartialClassName)) continue;
            if (match == null) {
                match = infos.get(fqn);
                continue;
            }
            throw new MappingException("More than one class has simple name: " + fullOrPartialClassName);
        }
        return match;
    }

    public List<ClassInfo> getClassInfosWithAnnotation(String annotation) {
        return this.annotationNameToClassInfo.get(annotation);
    }

    private void registerDefaultMethodConverters(ClassInfo classInfo, MethodInfo methodInfo) {
        if (!methodInfo.hasPropertyConverter() && !methodInfo.hasCompositeConverter() && (methodInfo.isGetter() || methodInfo.isSetter())) {
            if (methodInfo.getTypeDescriptor().contains(dateSignature)) {
                this.setDateMethodConverter(methodInfo);
            } else if (methodInfo.getTypeDescriptor().contains(bigIntegerSignature)) {
                this.setBigIntegerMethodConverter(methodInfo);
            } else if (methodInfo.getTypeDescriptor().contains(bigDecimalSignature)) {
                this.setBigDecimalMethodConverter(methodInfo);
            } else if (methodInfo.getTypeDescriptor().contains(byteArraySignature)) {
                methodInfo.setPropertyConverter(ConvertibleTypes.getByteArrayBase64Converter());
            } else if (methodInfo.getTypeDescriptor().contains(byteArrayWrapperSignature)) {
                methodInfo.setPropertyConverter(ConvertibleTypes.getByteArrayWrapperBase64Converter());
            } else {
                Class<?> methodType;
                if (methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert") != null) {
                    Class<?> entityAttributeType = ClassUtils.getType(methodInfo.getTypeDescriptor());
                    String graphTypeDescriptor = methodInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert").get("graphPropertyType", null);
                    if (graphTypeDescriptor == null) {
                        throw new MappingException("Found annotation to convert a " + entityAttributeType.getName() + " on " + classInfo.name() + '.' + methodInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                    }
                    methodInfo.setPropertyConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
                }
                if ((methodType = ClassUtils.getType(methodInfo.getTypeDescriptor())) != null) {
                    boolean enumConverterSet = false;
                    for (Class enumClass : this.enumTypes) {
                        if (!methodType.equals(enumClass) && (!methodType.isArray() || !methodType.getComponentType().equals(enumClass))) continue;
                        this.setEnumMethodConverter(methodInfo, enumClass);
                        enumConverterSet = true;
                        break;
                    }
                    if (!enumConverterSet && methodType.isEnum()) {
                        LOGGER.debug("Setting default enum converter for unscanned class " + classInfo.name() + ", method: " + methodInfo.getName());
                        this.setEnumMethodConverter(methodInfo, methodType);
                    }
                }
            }
        }
    }

    private void setEnumMethodConverter(MethodInfo methodInfo, Class enumClass) {
        if (methodInfo.isArray()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (methodInfo.isIterable()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setPropertyConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }

    private void setBigDecimalMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.isArray()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalArrayConverter());
        } else if (methodInfo.isIterable()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalConverter());
        }
    }

    private void setBigIntegerMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.isArray()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerArrayConverter());
        } else if (methodInfo.isIterable()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerConverter());
        }
    }

    private void setDateMethodConverter(MethodInfo methodInfo) {
        if (methodInfo.isArray()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getDateArrayConverter());
        } else if (methodInfo.isIterable()) {
            methodInfo.setPropertyConverter(ConvertibleTypes.getDateCollectionConverter(methodInfo.getCollectionClassname()));
        } else {
            methodInfo.setPropertyConverter(ConvertibleTypes.getDateConverter());
        }
    }

    private void registerDefaultFieldConverters(ClassInfo classInfo, FieldInfo fieldInfo) {
        if (!fieldInfo.hasPropertyConverter() && !fieldInfo.hasCompositeConverter()) {
            if (fieldInfo.getTypeDescriptor().contains(dateSignature)) {
                this.setDateFieldConverter(fieldInfo);
            } else if (fieldInfo.getTypeDescriptor().contains(bigIntegerSignature)) {
                this.setBigIntegerFieldConverter(fieldInfo);
            } else if (fieldInfo.getTypeDescriptor().contains(bigDecimalSignature)) {
                this.setBigDecimalConverter(fieldInfo);
            } else if (fieldInfo.getTypeDescriptor().contains(byteArraySignature)) {
                fieldInfo.setPropertyConverter(ConvertibleTypes.getByteArrayBase64Converter());
            } else if (fieldInfo.getTypeDescriptor().contains(byteArrayWrapperSignature)) {
                fieldInfo.setPropertyConverter(ConvertibleTypes.getByteArrayWrapperBase64Converter());
            } else {
                if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert") != null) {
                    Class<?> entityAttributeType = ClassUtils.getType(fieldInfo.getTypeDescriptor());
                    String graphTypeDescriptor = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.typeconversion.Convert").get("graphPropertyType", null);
                    if (graphTypeDescriptor == null) {
                        throw new MappingException("Found annotation to convert a " + entityAttributeType.getName() + " on " + classInfo.name() + '.' + fieldInfo.getName() + " but no target graph property type or specific AttributeConverter have been specified.");
                    }
                    fieldInfo.setPropertyConverter(new ProxyAttributeConverter(entityAttributeType, ClassUtils.getType(graphTypeDescriptor), this.conversionCallbackRegistry));
                }
                Class<?> fieldType = ClassUtils.getType(fieldInfo.getTypeDescriptor());
                boolean enumConverterSet = false;
                for (Class enumClass : this.enumTypes) {
                    if (!fieldType.equals(enumClass)) continue;
                    this.setEnumFieldConverter(fieldInfo, enumClass);
                    enumConverterSet = true;
                    break;
                }
                if (!enumConverterSet && fieldType.isEnum()) {
                    LOGGER.debug("Setting default enum converter for unscanned class " + classInfo.name() + ", field: " + fieldInfo.getName());
                    this.setEnumFieldConverter(fieldInfo, fieldType);
                }
            }
        }
    }

    private void setEnumFieldConverter(FieldInfo fieldInfo, Class enumClass) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumArrayConverter(enumClass));
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumCollectionConverter(enumClass, fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getEnumConverter(enumClass));
        }
    }

    private void setBigDecimalConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigDecimalConverter());
        }
    }

    private void setBigIntegerFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getBigIntegerConverter());
        }
    }

    private void setDateFieldConverter(FieldInfo fieldInfo) {
        if (fieldInfo.isArray()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateArrayConverter());
        } else if (fieldInfo.isIterable()) {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateCollectionConverter(fieldInfo.getCollectionClassname()));
        } else {
            fieldInfo.setPropertyConverter(ConvertibleTypes.getDateConverter());
        }
    }

    public Map<String, ClassInfo> getClassInfoMap() {
        return this.classNameToClassInfo;
    }

    public List<ClassInfo> getClassInfos(String interfaceName) {
        return this.interfaceNameToClassInfo.get(interfaceName);
    }
}

